/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.proxy.ClientProxy;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.render.entity.StockModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.fml.common.ProgressManager;

public class StockRenderCache {
    private static Map<String, StockModel> render_cache = new HashMap<String, StockModel>();
    private static boolean isCachePrimed = false;

    public static void clearRenderCache() {
        for (StockModel model : render_cache.values()) {
            model.freeGL();
        }
        render_cache = new HashMap<String, StockModel>();
        isCachePrimed = false;
    }

    private static void tryPrimeRenderCache() {
        if (isCachePrimed) {
            return;
        }
        isCachePrimed = true;
        ProgressManager.ProgressBar origBar = null;
        Iterator itr = ProgressManager.barIterator();
        while (itr.hasNext()) {
            origBar = (ProgressManager.ProgressBar)itr.next();
        }
        ProgressManager.pop(origBar);
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Uploading IR Textures", (int)DefinitionManager.getDefinitionNames().size());
        for (String def : DefinitionManager.getDefinitionNames()) {
            bar.step(DefinitionManager.getDefinition(def).name());
            ImmersiveRailroading.info(def, new Object[0]);
            StockModel renderer = StockRenderCache.getRender(def);
            if (!ConfigGraphics.enableItemRenderPriming) continue;
            renderer.bindTexture();
            renderer.draw();
            renderer.restoreTexture();
            ClientProxy.renderCacheLimiter.reset();
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    public static StockModel getRender(String defID) {
        EntityRollingStockDefinition def;
        if (!render_cache.containsKey(defID) && (def = DefinitionManager.getDefinition(defID)) != null) {
            render_cache.put(defID, new StockModel(def.getModel(), def.textureNames.keySet()));
        }
        return render_cache.get(defID);
    }

    public static void tryPrime() {
        StockRenderCache.tryPrimeRenderCache();
    }
}

