/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.model.obj.Material;
import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.model.obj.Vec2f;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class OBJTextureSheet {
    public Map<String, SubTexture> mappings;
    private int sheetWidth = 0;
    private int sheetHeight = 0;
    public final int textureID;
    private OBJModel model;

    public OBJTextureSheet(OBJModel model) {
        this(model, null);
    }

    public OBJTextureSheet(OBJModel model, String texPrefix) {
        this.model = model;
        model.offsetU = new byte[model.faceVerts.length / 9];
        model.offsetV = new byte[model.faceVerts.length / 9];
        Function<Integer, Integer> scaleFn = null;
        if (ConfigGraphics.textureScale != 1.0) {
            scaleFn = val -> {
                if (val == 1) {
                    return 1;
                }
                return (int)Math.ceil((double)val.intValue() / ConfigGraphics.textureScale);
            };
        }
        this.mappings = new HashMap<String, SubTexture>();
        HashSet<String> missing = new HashSet<String>();
        for (String groupName : model.groups.keySet()) {
            int[] quads;
            for (int face : quads = model.groups.get(groupName)) {
                String mtlName = model.faceMTLs[face];
                if (missing.contains(mtlName)) continue;
                if (!model.materials.containsKey(mtlName)) {
                    ImmersiveRailroading.warn("Missing material %s", mtlName);
                    missing.add(mtlName);
                    continue;
                }
                if (model.materials.get((Object)mtlName).texKd != null) {
                    String key = model.materials.get((Object)mtlName).texKd.toString();
                    if (!this.mappings.containsKey(key)) {
                        try {
                            ResourceLocation kd = model.materials.get((Object)mtlName).texKd;
                            if (texPrefix != null) {
                                String[] stringArray = kd.toString().split("/");
                                String fname = stringArray[stringArray.length - 1];
                                kd = new ResourceLocation(kd.toString().replaceAll(fname, texPrefix + "/" + fname));
                            }
                            this.mappings.put(key, new SubTexture(kd, model.materials.get((Object)mtlName).texKd, scaleFn));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            missing.add(mtlName);
                            continue;
                        }
                    }
                    ArrayList<Vec2f> vts = new ArrayList<Vec2f>();
                    for (int[] point : model.points(face)) {
                        Vec2f vt;
                        Vec2f vec2f = vt = point[1] != -1 ? model.vertexTextures(point[1]) : null;
                        if (vt == null) continue;
                        vts.add(vt);
                    }
                    if (vts.size() == 0) continue;
                    Vec2f vec2f = this.mappings.get(key).extendSpace(vts);
                    model.offsetU[face] = (byte)vec2f.x;
                    model.offsetV[face] = (byte)vec2f.y;
                    continue;
                }
                if (model.materials.get((Object)mtlName).Kd == null || this.mappings.containsKey(mtlName)) continue;
                Material currentMTL = model.materials.get(mtlName);
                int r = (int)(Math.max(0.0f, currentMTL.Kd.get(0) - model.darken) * 255.0f);
                int n = (int)(Math.max(0.0f, currentMTL.Kd.get(1) - model.darken) * 255.0f);
                int b2 = (int)(Math.max(0.0f, currentMTL.Kd.get(2) - model.darken) * 255.0f);
                int a2 = (int)(currentMTL.Kd.get(3) * 255.0f);
                this.mappings.put(mtlName, new SubTexture(mtlName, r, n, b2, a2));
            }
        }
        int maxSize = GL11.glGetInteger((int)3379);
        if (ConfigGraphics.overrideGPUTexSize != -1) {
            maxSize = ConfigGraphics.overrideGPUTexSize;
        }
        int currentX = 0;
        int currentY = 0;
        int rowHeight = 0;
        ArrayList<SubTexture> texs = new ArrayList<SubTexture>();
        texs.addAll(this.mappings.values());
        Collections.sort(texs, (a, b) -> b.size().compareTo(a.size()));
        for (SubTexture tex : texs) {
            if (currentX + tex.getAbsoluteWidth() > maxSize) {
                currentX = 0;
                currentY += rowHeight;
                rowHeight = 0;
            }
            rowHeight = Math.max(rowHeight, tex.getAbsoluteHeight());
            this.sheetWidth = Math.max(this.sheetWidth, currentX += tex.getAbsoluteWidth());
            this.sheetHeight = Math.max(this.sheetHeight, currentY + rowHeight);
        }
        this.textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)this.textureID);
        currentX = 0;
        currentY = 0;
        rowHeight = 0;
        TextureUtil.func_110991_a((int)this.textureID, (int)this.sheetWidth, (int)this.sheetHeight);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        ImmersiveRailroading.debug("Max Tex Size: %s", maxSize);
        if (this.sheetWidth > maxSize || this.sheetHeight > maxSize) {
            ImmersiveRailroading.warn("Sheet WxH: %sx%s", this.sheetWidth, this.sheetHeight);
        }
        for (SubTexture tex : texs) {
            ImmersiveRailroading.debug("%s copies %s x %s", tex.tex, tex.copiesU(), tex.copiesV());
            ImmersiveRailroading.debug("%s  actual %s x %s", tex.tex, tex.getAbsoluteWidth(), tex.getAbsoluteHeight());
            if (tex.getAbsoluteWidth() > maxSize) {
                ImmersiveRailroading.error("BAD TEXTURE, HACKING...", new Object[0]);
            }
            if (currentX + tex.getAbsoluteWidth() > maxSize) {
                currentX = 0;
                currentY += rowHeight;
                rowHeight = 0;
                ImmersiveRailroading.debug("NEXT_LINE", new Object[0]);
            }
            rowHeight = Math.max(rowHeight, tex.getAbsoluteHeight());
            tex.upload(this.textureID, currentX, currentY, this.sheetWidth, this.sheetHeight);
            currentX += tex.getAbsoluteWidth();
        }
    }

    public float convertU(String mtlName, float u) {
        ResourceLocation kd;
        if (this.model.materials.containsKey(mtlName) && (kd = this.model.materials.get((Object)mtlName).texKd) != null) {
            mtlName = kd.toString();
        }
        if (this.mappings.containsKey(mtlName)) {
            return this.mappings.get(mtlName).convertU(u);
        }
        return 0.0f;
    }

    public float convertV(String mtlName, float v) {
        ResourceLocation kd;
        if (this.model.materials.containsKey(mtlName) && (kd = this.model.materials.get((Object)mtlName).texKd) != null) {
            mtlName = kd.toString();
        }
        if (this.mappings.containsKey(mtlName)) {
            return this.mappings.get(mtlName).convertV(v);
        }
        return 0.0f;
    }

    public void freeGL() {
        GL11.glDeleteTextures((int)this.textureID);
    }

    public int samp(String mtlName, float u, float v) {
        ResourceLocation kd;
        if (this.model.materials.containsKey(mtlName) && (kd = this.model.materials.get((Object)mtlName).texKd) != null) {
            mtlName = kd.toString();
        }
        if (this.mappings.containsKey(mtlName)) {
            SubTexture mapping = this.mappings.get(mtlName);
            u = (u % 1.0f + 1.0f) % 1.0f;
            v = (v % 1.0f + 1.0f) % 1.0f;
            u *= (float)mapping.realWidth;
            v = (float)mapping.realHeight - v * (float)mapping.realHeight;
            v = (int)v;
            u = (int)u;
            return mapping.pixels[(int)Math.min(v * (float)mapping.realWidth + u, (float)(mapping.pixels.length - 1))];
        }
        return 0;
    }

    public boolean isFlatMaterial(String mtlName) {
        ResourceLocation kd;
        if (this.model.materials.containsKey(mtlName) && (kd = this.model.materials.get((Object)mtlName).texKd) != null) {
            mtlName = kd.toString();
        }
        if (this.mappings.containsKey(mtlName)) {
            return this.mappings.get(mtlName).isFlatMaterial;
        }
        return false;
    }

    public void freePx() {
        for (SubTexture tex : this.mappings.values()) {
            SubTexture.access$102(tex, null);
        }
    }

    private class SubTexture {
        public int realWidth;
        private int realHeight;
        private int sheetWidth;
        private int sheetHeight;
        private int originX;
        private int originY;
        private int minU = 0;
        private int minV = 0;
        private int maxU = 1;
        private int maxV = 1;
        public ResourceLocation tex;
        private boolean isFlatMaterial;
        private int[] pixels;

        SubTexture(ResourceLocation tex, ResourceLocation fallback, Function<Integer, Integer> scale) throws IOException {
            InputStream input;
            try {
                input = ImmersiveRailroading.proxy.getResourceStream(tex);
            }
            catch (FileNotFoundException ex) {
                input = ImmersiveRailroading.proxy.getResourceStream(fallback);
            }
            BufferedImage image = TextureUtil.func_177053_a((InputStream)input);
            input.close();
            this.realWidth = image.getWidth();
            this.realHeight = image.getHeight();
            if (scale != null) {
                image = this.convertToBufferedImage(image.getScaledInstance(scale.apply(this.realWidth), scale.apply(this.realHeight), 2));
                this.realWidth = image.getWidth();
                this.realHeight = image.getHeight();
            }
            this.tex = tex;
            this.isFlatMaterial = false;
            this.pixels = new int[this.realWidth * this.realHeight];
            image.getRGB(0, 0, this.realWidth, this.realHeight, this.pixels, 0, this.realWidth);
        }

        SubTexture(String name, int r, int g, int b, int a) {
            BufferedImage image = new BufferedImage(8, 8, 2);
            for (int x = 0; x < 8; ++x) {
                for (int y = 0; y < 8; ++y) {
                    image.setRGB(x, y, a << 24 | r << 16 | g << 8 | b);
                }
            }
            this.realWidth = image.getWidth();
            this.realHeight = image.getHeight();
            this.minU = 0;
            this.maxU = 1;
            this.minV = 0;
            this.maxV = 1;
            this.tex = new ResourceLocation("generated:" + name);
            this.isFlatMaterial = true;
            this.pixels = new int[this.realWidth * this.realHeight];
            image.getRGB(0, 0, this.realWidth, this.realHeight, this.pixels, 0, this.realWidth);
        }

        public Vec2f extendSpace(List<Vec2f> vts) {
            float vminU = vts.get((int)0).x;
            float vmaxU = vts.get((int)0).x;
            float vminV = -vts.get((int)0).y;
            float vmaxV = -vts.get((int)0).y;
            for (Vec2f vt : vts) {
                float u = vt.x;
                float v = -vt.y;
                vminU = Math.min(vminU, u);
                vmaxU = Math.max(vmaxU, u);
                vminV = Math.min(vminV, v);
                vmaxV = Math.max(vmaxV, v);
            }
            Vec2f offset = new Vec2f((float)Math.floor(vminU), (float)Math.floor(vminV));
            this.minU = MathHelper.func_76141_d((float)Math.min((float)this.minU, vminU -= offset.x));
            this.maxU = MathHelper.func_76123_f((float)Math.max((float)this.maxU, vmaxU -= offset.x));
            this.minV = MathHelper.func_76141_d((float)Math.min((float)this.minV, vminV -= offset.y));
            this.maxV = MathHelper.func_76123_f((float)Math.max((float)this.maxV, vmaxV -= offset.y));
            return offset;
        }

        public BufferedImage convertToBufferedImage(Image image) {
            BufferedImage newImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D g = newImage.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            return newImage;
        }

        public void upload(int textureID, int originX, int originY, int sheetWidth, int sheetHeight) {
            this.originX = originX;
            this.originY = originY;
            this.sheetWidth = sheetWidth;
            this.sheetHeight = sheetHeight;
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)(this.realWidth * this.realHeight * 4));
            for (int y = 0; y < this.realHeight; ++y) {
                for (int x = 0; x < this.realWidth; ++x) {
                    int pixel = this.pixels[y * this.realWidth + x];
                    buffer.put((byte)(pixel >> 16 & 0xFF));
                    buffer.put((byte)(pixel >> 8 & 0xFF));
                    buffer.put((byte)(pixel >> 0 & 0xFF));
                    buffer.put((byte)(pixel >> 24 & 0xFF));
                }
            }
            buffer.flip();
            for (int cU = 0; cU < this.copiesU(); ++cU) {
                for (int cV = 0; cV < this.copiesV(); ++cV) {
                    int offX = originX + this.realWidth * cU;
                    int offY = originY + this.realHeight * cV;
                    if (offX + this.realWidth > this.sheetWidth) {
                        return;
                    }
                    if (offY + this.realHeight > this.sheetHeight) {
                        return;
                    }
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)offX, (int)offY, (int)this.realWidth, (int)this.realHeight, (int)6408, (int)5121, (ByteBuffer)buffer);
                }
            }
            if (!ConfigGraphics.enableIconCache) {
                this.pixels = null;
            }
        }

        public int copiesU() {
            return this.maxU - this.minU;
        }

        public int copiesV() {
            return this.maxV - this.minV;
        }

        public int getAbsoluteWidth() {
            return this.realWidth * this.copiesU();
        }

        public int getAbsoluteHeight() {
            return this.realHeight * this.copiesV();
        }

        public float convertU(float relativeU) {
            if (this.isFlatMaterial) {
                relativeU = 0.5f;
            }
            return (float)this.originX / (float)this.sheetWidth + (relativeU - (float)this.minU) * ((float)this.realWidth / (float)this.sheetWidth);
        }

        public float convertV(float relativeV) {
            if (this.isFlatMaterial) {
                relativeV = 0.5f;
            }
            return (float)this.originY / (float)this.sheetHeight + (relativeV - (float)this.minV) * ((float)this.realHeight / (float)this.sheetHeight);
        }

        public Integer size() {
            return this.getAbsoluteHeight();
        }

        static /* synthetic */ int[] access$102(SubTexture x0, int[] x1) {
            x0.pixels = x1;
            return x1;
        }
    }
}

