/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.model.obj.Material;
import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.model.obj.Vec2f;
import cam72cam.immersiverailroading.proxy.ClientProxy;
import cam72cam.immersiverailroading.render.OBJTextureSheet;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import util.Matrix4;

public class OBJRender {
    public OBJModel model;
    public Map<String, OBJTextureSheet> textures = new HashMap<String, OBJTextureSheet>();
    private int prevTexture = -1;
    private Integer displayList = null;
    public Map<Double, Map<Iterable<String>, Integer>> displayLists = new HashMap<Double, Map<Iterable<String>, Integer>>();

    public OBJRender(OBJModel model) {
        this(model, null);
    }

    public OBJRender(OBJModel model, Collection<String> textureNames) {
        this.model = model;
        if (textureNames != null && textureNames.size() > 1) {
            for (String name : textureNames) {
                this.textures.put(name, new OBJTextureSheet(model, name));
            }
        } else {
            this.textures.put(null, new OBJTextureSheet(model));
        }
    }

    public boolean hasTexture() {
        return true;
    }

    public void bindTexture() {
        this.bindTexture(null);
    }

    public void bindTexture(String texName) {
        if (this.hasTexture()) {
            int currentTexture = GL11.glGetInteger((int)32873);
            if (this.textures.get(texName) == null) {
                texName = null;
            }
            if (currentTexture != this.textures.get((Object)texName).textureID) {
                this.prevTexture = currentTexture;
                GL11.glBindTexture((int)3553, (int)this.textures.get((Object)texName).textureID);
            }
        }
    }

    public void restoreTexture() {
        if (this.hasTexture() && this.prevTexture != -1) {
            GL11.glBindTexture((int)3553, (int)this.prevTexture);
            this.prevTexture = -1;
        }
    }

    public void draw() {
        if (this.displayList == null) {
            if (!ClientProxy.renderCacheLimiter.canRender()) {
                return;
            }
            this.displayList = ClientProxy.renderCacheLimiter.newList(() -> this.drawDirect());
        }
        GL11.glCallList((int)this.displayList);
    }

    public void drawDirect() {
        this.drawDirectGroups(this.model.groups.keySet());
    }

    public void drawDirect(double scale) {
        this.drawDirectGroups(this.model.groups.keySet(), scale);
    }

    public void drawGroups(Iterable<String> groupNames, double scale) {
        if (!this.displayLists.containsKey(scale)) {
            this.displayLists.put(scale, new HashMap());
        }
        if (!this.displayLists.get(scale).containsKey(groupNames)) {
            if (!ClientProxy.renderCacheLimiter.canRender()) {
                return;
            }
            int groupsDisplayList = GL11.glGenLists((int)1);
            groupsDisplayList = ClientProxy.renderCacheLimiter.newList(() -> this.drawDirectGroups(groupNames, scale));
            this.displayLists.get(scale).put(groupNames, groupsDisplayList);
        }
        GL11.glCallList((int)this.displayLists.get(scale).get(groupNames));
    }

    public void drawGroups(Iterable<String> groupNames) {
        this.drawGroups(groupNames, 1.0);
    }

    public void drawDirectGroups(Iterable<String> groupNames) {
        this.drawDirectGroups(groupNames, 1.0);
    }

    public void drawDirectGroups(Iterable<String> groupNames, double scale) {
        this.drawDirectGroups(groupNames, scale, new Matrix4());
    }

    public void drawDirectGroups(Iterable<String> groupNames, double scale, Matrix4 m) {
        ArrayList<Integer> quads = new ArrayList<Integer>();
        boolean has_vn = true;
        for (String group : groupNames) {
            if (group.contains("EXHAUST_") || group.contains("CHIMNEY_") || group.contains("PRESSURE_VALVE_") || group.contains("CHIMINEY_")) continue;
            for (int face : this.model.groups.get(group)) {
                quads.add(face);
            }
        }
        FloatBuffer vertexBuffer = BufferUtils.createFloatBuffer((int)(quads.size() * 3 * 3));
        FloatBuffer normalBuffer = BufferUtils.createFloatBuffer((int)(quads.size() * 3 * 3));
        FloatBuffer colorBuffer = BufferUtils.createFloatBuffer((int)(quads.size() * 3 * 4));
        FloatBuffer texBuffer = BufferUtils.createFloatBuffer((int)(quads.size() * 3 * 2));
        Iterator iterator = quads.iterator();
        while (iterator.hasNext()) {
            int face;
            face = (Integer)iterator.next();
            String mtlName = this.model.faceMTLs[face];
            Material currentMTL = this.model.materials.get(mtlName);
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            float a = 1.0f;
            OBJTextureSheet texture = this.textures.get(null);
            if (currentMTL != null) {
                if (currentMTL.Kd != null) {
                    float mult = 1.0f - this.model.darken * 5.0f;
                    if (texture.isFlatMaterial(mtlName)) {
                        r = 1.0f;
                        g = 1.0f;
                        b = 1.0f;
                    } else {
                        r = currentMTL.Kd.get(0);
                        g = currentMTL.Kd.get(1);
                        b = currentMTL.Kd.get(2);
                    }
                    r = Math.max(0.0f, r * mult);
                    g = Math.max(0.0f, g * mult);
                    b = Math.max(0.0f, b * mult);
                    a = currentMTL.Kd.get(3);
                }
            } else {
                ImmersiveRailroading.warn("Missing group %s", mtlName);
            }
            for (int[] point : this.model.points(face)) {
                Vec3d v = this.model.vertices(point[0]);
                Vec2f vt = point[1] != -1 ? this.model.vertexTextures(point[1]) : null;
                Vec3d vn = point[2] != -1 ? this.model.vertexNormals(point[2]) : null;
                v = m.apply(v);
                vertexBuffer.put((float)(v.field_72450_a * scale));
                vertexBuffer.put((float)(v.field_72448_b * scale));
                vertexBuffer.put((float)(v.field_72449_c * scale));
                if (vn != null) {
                    normalBuffer.put((float)vn.field_72450_a);
                    normalBuffer.put((float)vn.field_72448_b);
                    normalBuffer.put((float)vn.field_72449_c);
                } else {
                    has_vn = false;
                }
                if (vt != null) {
                    texBuffer.put(texture.convertU(mtlName, vt.x - (float)this.model.offsetU[face]));
                    texBuffer.put(texture.convertV(mtlName, -vt.y - (float)this.model.offsetV[face]));
                } else {
                    texBuffer.put(texture.convertU(mtlName, 0.0f));
                    texBuffer.put(texture.convertV(mtlName, 0.0f));
                }
                colorBuffer.put(r);
                colorBuffer.put(g);
                colorBuffer.put(b);
                colorBuffer.put(a);
            }
        }
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glEnableClientState((int)32886);
        if (has_vn) {
            GL11.glEnableClientState((int)32885);
        }
        vertexBuffer.flip();
        colorBuffer.flip();
        normalBuffer.flip();
        texBuffer.flip();
        GL11.glTexCoordPointer((int)2, (int)8, (FloatBuffer)texBuffer);
        GL11.glColorPointer((int)4, (int)16, (FloatBuffer)colorBuffer);
        if (has_vn) {
            GL11.glNormalPointer((int)12, (FloatBuffer)normalBuffer);
        }
        GL11.glVertexPointer((int)3, (int)12, (FloatBuffer)vertexBuffer);
        GL11.glDrawArrays((int)4, (int)0, (int)(quads.size() * 3));
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32886);
        if (has_vn) {
            GL11.glDisableClientState((int)32885);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void freeGL() {
        if (this.hasTexture()) {
            for (OBJTextureSheet oBJTextureSheet : this.textures.values()) {
                oBJTextureSheet.freeGL();
            }
        }
        if (this.displayList != null) {
            GL11.glDeleteLists((int)this.displayList, (int)1);
        }
        for (Map map : this.displayLists.values()) {
            for (Integer dl : map.values()) {
                GL11.glDeleteLists((int)dl, (int)1);
            }
        }
    }
}

