/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.ARBShaderObjects;

public class GLSLShader {
    private int program;
    private int oldProc;

    public GLSLShader(String vert, String frag) {
        int vertShader = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
        int fragShader = ARBShaderObjects.glCreateShaderObjectARB((int)35632);
        ARBShaderObjects.glShaderSourceARB((int)vertShader, (CharSequence)this.readShader(vert));
        ARBShaderObjects.glCompileShaderARB((int)vertShader);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)vertShader, (int)35713) == 0) {
            throw new RuntimeException("Error creating shader: " + GLSLShader.getLogInfo(vertShader));
        }
        ARBShaderObjects.glShaderSourceARB((int)fragShader, (CharSequence)this.readShader(frag));
        ARBShaderObjects.glCompileShaderARB((int)fragShader);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)fragShader, (int)35713) == 0) {
            throw new RuntimeException("Error creating shader: " + GLSLShader.getLogInfo(fragShader));
        }
        this.program = ARBShaderObjects.glCreateProgramObjectARB();
        ARBShaderObjects.glAttachObjectARB((int)this.program, (int)vertShader);
        ARBShaderObjects.glAttachObjectARB((int)this.program, (int)fragShader);
        ARBShaderObjects.glLinkProgramARB((int)this.program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.program, (int)35714) == 0) {
            throw new RuntimeException("Error creating shader: " + GLSLShader.getLogInfo(this.program));
        }
        ARBShaderObjects.glValidateProgramARB((int)this.program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.program, (int)35715) == 0) {
            throw new RuntimeException("Error creating shader: " + GLSLShader.getLogInfo(this.program));
        }
    }

    public void bind() {
        this.oldProc = ARBShaderObjects.glGetHandleARB((int)35648);
        ARBShaderObjects.glUseProgramObjectARB((int)this.program);
    }

    public void unbind() {
        ARBShaderObjects.glUseProgramObjectARB((int)this.oldProc);
    }

    public void paramFloat(String name, float ... params) {
        switch (params.length) {
            case 1: {
                ARBShaderObjects.glUniform1fARB((int)ARBShaderObjects.glGetUniformLocationARB((int)this.program, (CharSequence)name), (float)params[0]);
                break;
            }
            case 3: {
                ARBShaderObjects.glUniform3fARB((int)ARBShaderObjects.glGetUniformLocationARB((int)this.program, (CharSequence)name), (float)params[0], (float)params[1], (float)params[2]);
            }
        }
    }

    private String readShader(String fname) {
        InputStream input;
        try {
            input = ImmersiveRailroading.proxy.getResourceStream(new ResourceLocation("immersiverailroading:particles/" + fname));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Error reading shader " + fname);
        }
        Scanner reader = new Scanner(input);
        String text = "";
        while (reader.hasNextLine()) {
            text = text + reader.nextLine();
        }
        reader.close();
        return text;
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }
}

