/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.util.FluidQuantity;
import com.google.gson.JsonObject;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class LocomotiveDieselDefinition
extends LocomotiveDefinition {
    private FluidQuantity fuelCapacity;
    private int fuelEfficiency;
    public ResourceLocation idle;
    public ResourceLocation horn;
    public boolean muliUnitCapable;

    public LocomotiveDieselDefinition(String defID, JsonObject data) throws Exception {
        super(defID, data);
        if (this.fuelCapacity == null) {
            this.fuelCapacity = FluidQuantity.ZERO;
        }
    }

    @Override
    protected Set<String> parseComponents() {
        Set<String> groups = super.parseComponents();
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.FUEL_TANK, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.ALTERNATOR, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.ENGINE_BLOCK, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.CRANKSHAFT, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.GEARBOX, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.FLUID_COUPLING, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.FINAL_DRIVE, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.TORQUE_CONVERTER, this, groups), true);
        for (int i = 0; i < 20; ++i) {
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.PISTON_X, this, groups, i), true);
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.DIESEL_EXHAUST_X, this, groups, i), false);
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.FAN_X, this, groups, i), true);
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.DRIVE_SHAFT_X, this, groups, i), true);
        }
        return groups;
    }

    @Override
    public void parseJson(JsonObject data) throws Exception {
        super.parseJson(data);
        JsonObject properties = data.get("properties").getAsJsonObject();
        this.fuelCapacity = FluidQuantity.FromLiters((int)Math.ceil((double)properties.get("fuel_capacity_l").getAsInt() * this.internal_inv_scale * 10.0));
        this.fuelEfficiency = properties.get("fuel_efficiency_%").getAsInt();
        this.muliUnitCapable = properties.has("multi_unit_capable") ? properties.get("multi_unit_capable").getAsBoolean() : true;
        JsonObject sounds = data.has("sounds") ? data.get("sounds").getAsJsonObject() : null;
        this.idle = sounds != null && sounds.has("idle") ? new ResourceLocation("immersiverailroading", sounds.get("idle").getAsString()) : new ResourceLocation("immersiverailroading", "sounds/diesel/default/idle.ogg");
        this.horn = sounds != null && sounds.has("horn") ? new ResourceLocation("immersiverailroading", sounds.get("horn").getAsString()) : new ResourceLocation("immersiverailroading", "sounds/diesel/default/horn.ogg");
    }

    @Override
    public EntityRollingStock instance(World world) {
        return new LocomotiveDiesel(world, this.defID);
    }

    public FluidQuantity getFuelCapacity(Gauge gauge) {
        return this.fuelCapacity.scale(gauge.scale()).min(FluidQuantity.FromBuckets(1)).roundBuckets();
    }

    public int getFuelEfficiency() {
        return this.fuelEfficiency;
    }
}

