/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.registry.CarFreightDefinition;
import cam72cam.immersiverailroading.registry.CarPassengerDefinition;
import cam72cam.immersiverailroading.registry.CarTankDefinition;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.HandCarDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDieselDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveSteamDefinition;
import cam72cam.immersiverailroading.registry.TenderDefinition;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ProgressManager;

public class DefinitionManager {
    private static Map<String, EntityRollingStockDefinition> definitions;
    private static Map<String, JsonLoader> jsonLoaders;

    private static void initGauges() throws IOException {
        ResourceLocation gauges_json = new ResourceLocation("immersiverailroading", "rolling_stock/gauges.json");
        ArrayList<Double> toRemove = new ArrayList<Double>();
        List<InputStream> inputs = ImmersiveRailroading.proxy.getResourceStreamAll(gauges_json);
        for (InputStream input : inputs) {
            JsonParser parser = new JsonParser();
            JsonObject gauges = parser.parse((Reader)new InputStreamReader(input)).getAsJsonObject();
            input.close();
            if (gauges.has("register")) {
                for (Map.Entry gauge : gauges.get("register").getAsJsonObject().entrySet()) {
                    Gauge.register(((JsonElement)gauge.getValue()).getAsDouble(), (String)gauge.getKey());
                }
            }
            if (!gauges.has("remove")) continue;
            for (Map.Entry gauge : gauges.get("remove").getAsJsonArray()) {
                toRemove.add(gauge.getAsDouble());
            }
        }
        Iterator<InputStream> iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            double gauge = (Double)((Object)iterator.next());
            Gauge.remove(gauge);
        }
    }

    public static void initDefinitions() throws IOException {
        DefinitionManager.initGauges();
        definitions = new LinkedHashMap<String, EntityRollingStockDefinition>();
        Set<String> defTypes = jsonLoaders.keySet();
        ArrayList<String> blacklist = new ArrayList<String>();
        ResourceLocation blacklist_json = new ResourceLocation("immersiverailroading", "rolling_stock/blacklist.json");
        List<InputStream> inputs = ImmersiveRailroading.proxy.getResourceStreamAll(blacklist_json);
        for (InputStream inputStream : inputs) {
            JsonParser parser = new JsonParser();
            JsonObject stock = parser.parse((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
            inputStream.close();
            for (String defType : defTypes) {
                if (!stock.has(defType)) continue;
                for (JsonElement defName : stock.get(defType).getAsJsonArray()) {
                    blacklist.add(defName.getAsString());
                }
            }
        }
        ResourceLocation stock_json = new ResourceLocation("immersiverailroading", "rolling_stock/stock.json");
        inputs = ImmersiveRailroading.proxy.getResourceStreamAll(stock_json);
        for (InputStream input : inputs) {
            JsonParser parser = new JsonParser();
            JsonObject stock = parser.parse((Reader)new InputStreamReader(input)).getAsJsonObject();
            input.close();
            int steps = 0;
            for (String defType : defTypes) {
                if (!stock.has(defType)) continue;
                steps += stock.get(defType).getAsJsonArray().size();
            }
            ProgressManager.ProgressBar bar = ProgressManager.push((String)"Loading Models", (int)steps);
            for (String defType : defTypes) {
                if (!stock.has(defType)) continue;
                for (JsonElement defName : stock.get(defType).getAsJsonArray()) {
                    bar.step(defName.getAsString());
                    if (blacklist.contains(defName.getAsString())) {
                        ImmersiveRailroading.info("Skipping blacklisted %s", defName.getAsString());
                        continue;
                    }
                    try {
                        String defID = String.format("rolling_stock/%s/%s.json", defType, defName.getAsString());
                        JsonObject data = DefinitionManager.getJsonData(defID);
                        definitions.put(defID, jsonLoaders.get(defType).apply(defID, data));
                    }
                    catch (Exception ex) {
                        ImmersiveRailroading.catching(ex);
                    }
                }
            }
            ProgressManager.pop((ProgressManager.ProgressBar)bar);
        }
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Generating Heightmap", (int)definitions.size());
        for (EntityRollingStockDefinition def : definitions.values()) {
            progressBar.step(def.name());
            def.initHeightMap();
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static JsonObject getJsonData(String defID) throws IOException {
        ImmersiveRailroading.info("Loading stock " + defID, new Object[0]);
        ResourceLocation resource = new ResourceLocation("immersiverailroading", defID);
        InputStream input = ImmersiveRailroading.proxy.getResourceStream(resource);
        JsonParser parser = new JsonParser();
        JsonObject result = parser.parse((Reader)new InputStreamReader(input)).getAsJsonObject();
        input.close();
        return result;
    }

    public static EntityRollingStockDefinition getDefinition(String defID) {
        return definitions.get(defID);
    }

    public static Collection<EntityRollingStockDefinition> getDefinitions() {
        return definitions.values();
    }

    public static Set<String> getDefinitionNames() {
        return definitions.keySet();
    }

    static {
        jsonLoaders = new LinkedHashMap<String, JsonLoader>();
        jsonLoaders.put("locomotives", (defID, data) -> {
            String era;
            switch (era = data.get("era").getAsString()) {
                case "steam": {
                    return new LocomotiveSteamDefinition(defID, data);
                }
                case "diesel": {
                    return new LocomotiveDieselDefinition(defID, data);
                }
            }
            ImmersiveRailroading.warn("Invalid era %s in %s", era, defID);
            return null;
        });
        jsonLoaders.put("tender", (defID, data) -> new TenderDefinition(defID, data));
        jsonLoaders.put("passenger", (defID, data) -> new CarPassengerDefinition(defID, data));
        jsonLoaders.put("freight", (defID, data) -> new CarFreightDefinition(defID, data));
        jsonLoaders.put("tank", (defID, data) -> new CarTankDefinition(defID, data));
        jsonLoaders.put("hand_car", (defID, data) -> new HandCarDefinition(defID, data));
    }

    @FunctionalInterface
    private static interface JsonLoader {
        public EntityRollingStockDefinition apply(String var1, JsonObject var2) throws Exception;
    }
}

