/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.proxy;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityRidableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.proxy.CommonProxy;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.server.FMLServerHandler;

@Mod.EventBusSubscriber(value={Side.SERVER})
public class ServerProxy
extends CommonProxy {
    private static int tickCount = 0;
    private static Map<UUID, UUID> logoffRide = new HashMap<UUID, UUID>();

    @Override
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        super.preInit(event);
        for (EntityRollingStockDefinition def : DefinitionManager.getDefinitions()) {
            def.clearModel();
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int entityID, int nop1, int nop2) {
        return null;
    }

    @Override
    public World getWorld(int dimension) {
        return FMLServerHandler.instance().getServer().func_71218_a(dimension);
    }

    private InputStream getEmbeddedResourceStream(ResourceLocation location) throws IOException {
        URL url = ImmersiveRailroading.class.getResource(this.pathString(location, true));
        return url != null ? ImmersiveRailroading.class.getResourceAsStream(this.pathString(location, true)) : null;
    }

    @Override
    public List<InputStream> getResourceStreamAll(ResourceLocation location) throws IOException {
        ArrayList<InputStream> res = new ArrayList<InputStream>();
        InputStream stream = this.getEmbeddedResourceStream(location);
        if (stream != null) {
            res.add(stream);
        }
        res.addAll(this.getFileResourceStreams(location));
        return res;
    }

    @Override
    public void addPreview(int dimension, TileRailPreview preview) {
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        EntityRollingStock stock;
        String defID;
        EntityRollingStockDefinition def;
        if (event.getEntity() instanceof EntityRollingStock && (def = DefinitionManager.getDefinition(defID = (stock = (EntityRollingStock)event.getEntity()).getDefinitionID())) == null) {
            String error = String.format("Missing definition %s, do you have all of the required resource packs?", defID);
            ImmersiveRailroading.error(error, new Object[0]);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (logoffRide.containsKey(player.func_110124_au())) {
            for (Entity ent : world.field_72996_f) {
                if (ent.func_110124_au() != logoffRide.get(player.func_110124_au())) continue;
                System.out.println("WOOO");
                player.func_184205_a(ent, true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        if (player.func_184187_bx() instanceof EntityRidableRollingStock) {
            logoffRide.put(player.func_110124_au(), player.func_184187_bx().func_110124_au());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ++tickCount;
    }

    @Override
    public int getTicks() {
        return tickCount;
    }
}

