/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.proxy;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRBlocks;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.blocks.BlockRailBase;
import cam72cam.immersiverailroading.blocks.BlockRailPreview;
import cam72cam.immersiverailroading.entity.CarFreight;
import cam72cam.immersiverailroading.entity.CarPassenger;
import cam72cam.immersiverailroading.entity.CarTank;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.HandCar;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.gui.FreightContainer;
import cam72cam.immersiverailroading.gui.SteamHammerContainer;
import cam72cam.immersiverailroading.gui.SteamLocomotiveContainer;
import cam72cam.immersiverailroading.gui.TankContainer;
import cam72cam.immersiverailroading.gui.TenderContainer;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.multiblock.BoilerRollerMultiblock;
import cam72cam.immersiverailroading.multiblock.CastingMultiblock;
import cam72cam.immersiverailroading.multiblock.MultiblockRegistry;
import cam72cam.immersiverailroading.multiblock.PlateRollerMultiblock;
import cam72cam.immersiverailroading.multiblock.RailRollerMultiblock;
import cam72cam.immersiverailroading.multiblock.SteamHammerMultiblock;
import cam72cam.immersiverailroading.net.BuildableStockSyncPacket;
import cam72cam.immersiverailroading.net.ItemRailUpdatePacket;
import cam72cam.immersiverailroading.net.KeyPressPacket;
import cam72cam.immersiverailroading.net.MRSSyncPacket;
import cam72cam.immersiverailroading.net.MousePressPacket;
import cam72cam.immersiverailroading.net.MultiblockSelectCraftPacket;
import cam72cam.immersiverailroading.net.PaintSyncPacket;
import cam72cam.immersiverailroading.net.PassengerPositionsPacket;
import cam72cam.immersiverailroading.net.PreviewRenderPacket;
import cam72cam.immersiverailroading.net.SoundPacket;
import cam72cam.immersiverailroading.proxy.ChunkManager;
import cam72cam.immersiverailroading.proxy.IRCommand;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.sound.ISound;
import cam72cam.immersiverailroading.thirdparty.CompatLoader;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailGag;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import cam72cam.immersiverailroading.util.OreHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(modid="immersiverailroading")
public abstract class CommonProxy
implements IGuiHandler {
    protected static List<Class<? extends EntityRollingStock>> entityClasses = new ArrayList<Class<? extends EntityRollingStock>>();
    protected String configDir;
    private static String cacheDir;

    public static String getCacheFile(String fname) {
        return cacheDir + fname;
    }

    public void preInit(FMLPreInitializationEvent event) throws IOException {
        this.configDir = event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "immersiverailroading";
        cacheDir = this.configDir + File.separator + ".." + File.separator + ".." + File.separator + "cache" + File.separator;
        new File(this.configDir).mkdirs();
        new File(cacheDir).mkdirs();
        DefinitionManager.initDefinitions();
        OreHelper.IR_RAIL_BED.add(Blocks.field_150336_V);
        OreHelper.IR_RAIL_BED.add(Blocks.field_150347_e);
        OreHelper.IR_RAIL_BED.add(new ItemStack(Blocks.field_192443_dR, 1, Short.MAX_VALUE));
        OreHelper.IR_RAIL_BED.add(Blocks.field_150346_d);
        OreHelper.IR_RAIL_BED.add(Blocks.field_150351_n);
        OreHelper.IR_RAIL_BED.add(new ItemStack(Blocks.field_150405_ch, 1, Short.MAX_VALUE));
        OreHelper.IR_RAIL_BED.add(new ItemStack(Blocks.field_150364_r, 1, Short.MAX_VALUE));
        OreHelper.IR_RAIL_BED.add(new ItemStack(Blocks.field_150363_s, 1, Short.MAX_VALUE));
        OreHelper.IR_RAIL_BED.add(Blocks.field_150385_bj);
        OreHelper.IR_RAIL_BED.add(new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE));
    }

    public void init(FMLInitializationEvent event) {
        ImmersiveRailroading.net.registerMessage(MRSSyncPacket.Handler.class, MRSSyncPacket.class, 0, Side.CLIENT);
        ImmersiveRailroading.net.registerMessage(KeyPressPacket.Handler.class, KeyPressPacket.class, 1, Side.SERVER);
        ImmersiveRailroading.net.registerMessage(PassengerPositionsPacket.Handler.class, PassengerPositionsPacket.class, 2, Side.CLIENT);
        ImmersiveRailroading.net.registerMessage(MousePressPacket.Handler.class, MousePressPacket.class, 6, Side.SERVER);
        ImmersiveRailroading.net.registerMessage(ItemRailUpdatePacket.Handler.class, ItemRailUpdatePacket.class, 7, Side.SERVER);
        ImmersiveRailroading.net.registerMessage(BuildableStockSyncPacket.Handler.class, BuildableStockSyncPacket.class, 8, Side.CLIENT);
        ImmersiveRailroading.net.registerMessage(MultiblockSelectCraftPacket.Handler.class, MultiblockSelectCraftPacket.class, 9, Side.SERVER);
        ImmersiveRailroading.net.registerMessage(SoundPacket.Handler.class, SoundPacket.class, 10, Side.CLIENT);
        ImmersiveRailroading.net.registerMessage(PaintSyncPacket.Handler.class, PaintSyncPacket.class, 11, Side.CLIENT);
        ImmersiveRailroading.net.registerMessage(PreviewRenderPacket.Handler.class, PreviewRenderPacket.class, 12, Side.CLIENT);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ImmersiveRailroading.instance, (IGuiHandler)this);
        CompatLoader.load();
        MultiblockRegistry.register("STEAM_HAMMER", new SteamHammerMultiblock());
        MultiblockRegistry.register("PLATE_MACHINE", new PlateRollerMultiblock());
        MultiblockRegistry.register("RAIL_MACHINE", new RailRollerMultiblock());
        MultiblockRegistry.register("BOILER_MACHINE", new BoilerRollerMultiblock());
        MultiblockRegistry.register("CASTING", new CastingMultiblock());
    }

    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new IRCommand());
    }

    public abstract World getWorld(int var1);

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)event.getRegistry();
        if (!OreDictionary.doesOreNameExist((String)"ingotSteel")) {
            modRegistry.remove(new ResourceLocation("immersiverailroading:wrench"));
            modRegistry.remove(new ResourceLocation("immersiverailroading:hook"));
            modRegistry.remove(new ResourceLocation("immersiverailroading:manual"));
            modRegistry.remove(new ResourceLocation("immersiverailroading:track blueprint"));
        } else {
            modRegistry.remove(new ResourceLocation("immersiverailroading:wrench_iron"));
            modRegistry.remove(new ResourceLocation("immersiverailroading:hook_iron"));
            modRegistry.remove(new ResourceLocation("immersiverailroading:manual_iron"));
            modRegistry.remove(new ResourceLocation("immersiverailroading:track blueprint_iron"));
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)IRBlocks.BLOCK_RAIL_GAG);
        event.getRegistry().register((IForgeRegistryEntry)IRBlocks.BLOCK_RAIL);
        event.getRegistry().register((IForgeRegistryEntry)IRBlocks.BLOCK_RAIL_PREVIEW);
        event.getRegistry().register((IForgeRegistryEntry)IRBlocks.BLOCK_MULTIBLOCK);
        GameRegistry.registerTileEntity(TileRailGag.class, (String)"block_rail_gag");
        GameRegistry.registerTileEntity(TileRail.class, (String)"block_rail");
        GameRegistry.registerTileEntity(TileRailPreview.class, (String)"block_rail_preview");
        GameRegistry.registerTileEntity(TileMultiblock.class, (String)"multiblock");
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)IRItems.ITEM_TRACK_BLUEPRINT);
        event.getRegistry().register((IForgeRegistryEntry)IRItems.ITEM_ROLLING_STOCK);
        event.getRegistry().register((IForgeRegistryEntry)IRItems.ITEM_ROLLING_STOCK_COMPONENT);
        event.getRegistry().register((IForgeRegistryEntry)IRItems.ITEM_LARGE_WRENCH);
        event.getRegistry().register((IForgeRegistryEntry)IRItems.ITEM_HOOK);
        event.getRegistry().register((IForgeRegistryEntry)IRItems.ITEM_AUGMENT);
        event.getRegistry().register((IForgeRegistryEntry)IRItems.ITEM_MANUAL);
        event.getRegistry().register((IForgeRegistryEntry)IRItems.ITEM_RAIL);
        event.getRegistry().register((IForgeRegistryEntry)IRItems.ITEM_PLATE);
        event.getRegistry().register((IForgeRegistryEntry)IRItems.ITEM_CAST_RAIL);
        event.getRegistry().register((IForgeRegistryEntry)IRItems.ITEM_CONDUCTOR_WHISTLE);
        event.getRegistry().register((IForgeRegistryEntry)IRItems.ITEM_PAINT_BRUSH);
        event.getRegistry().register((IForgeRegistryEntry)IRItems.ITEM_GOLDEN_SPIKE);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        int lastEntityID = 0;
        for (Class<? extends EntityRollingStock> type : entityClasses) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("immersiverailroading", type.getSimpleName()), type, (String)type.getSimpleName(), (int)(++lastEntityID), (Object)ImmersiveRailroading.instance, (int)512, (int)20, (boolean)false);
        }
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (!BlockRailBase.tryBreakRail((IBlockAccess)event.getWorld(), event.getPos())) {
            event.setCanceled(true);
        } else if (BlockRailPreview.tryBreakPreview(event.getWorld(), event.getPos(), event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!event.world.field_72995_K) {
            ChunkManager.handleWorldTick(event.world);
            WorldServer world = event.world.func_73046_m().func_71218_a(event.world.field_73011_w.getDimension());
            List entities = world.func_175644_a(EntityCoupleableRollingStock.class, EntitySelectors.field_94557_a);
            for (EntityCoupleableRollingStock stock : entities) {
                if (!(stock instanceof Locomotive)) continue;
                stock = stock.findByUUID(stock.getPersistentID());
                stock.tickPosRemainingCheck();
            }
            for (EntityCoupleableRollingStock stock : entities) {
                stock = stock.findByUUID(stock.getPersistentID());
                stock.tickPosRemainingCheck();
            }
            try {
                Thread.sleep(Config.ConfigDebug.lagServer);
            }
            catch (InterruptedException e) {
                ImmersiveRailroading.catching(e);
            }
        }
    }

    public abstract int getTicks();

    public abstract List<InputStream> getResourceStreamAll(ResourceLocation var1) throws IOException;

    public InputStream getResourceStream(ResourceLocation location) throws IOException {
        InputStream chosen = null;
        for (InputStream strm : this.getResourceStreamAll(location)) {
            if (chosen == null) {
                chosen = strm;
                continue;
            }
            strm.close();
        }
        if (chosen == null) {
            throw new FileNotFoundException(location.toString());
        }
        return chosen;
    }

    protected String pathString(ResourceLocation location, boolean startingSlash) {
        return (startingSlash ? "/" : "") + "assets/" + location.func_110624_b() + "/" + location.func_110623_a();
    }

    protected List<InputStream> getFileResourceStreams(ResourceLocation location) throws IOException {
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        File folder = new File(this.configDir);
        if (folder.exists()) {
            if (folder.isDirectory()) {
                File[] files;
                for (File file : files = folder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".zip");
                    }
                })) {
                    ZipFile resourcePack = new ZipFile(file);
                    ZipEntry entry = resourcePack.getEntry(this.pathString(location, false));
                    if (entry != null) {
                        InputStream stream = resourcePack.getInputStream(entry);
                        streams.add(new ByteArrayInputStream(IOUtils.toByteArray((InputStream)stream)));
                    }
                    resourcePack.close();
                }
            } else {
                ImmersiveRailroading.error("Expecting " + this.configDir + " to be a directory", new Object[0]);
            }
        } else {
            folder.mkdirs();
        }
        return streams;
    }

    public ISound newSound(ResourceLocation oggLocation, boolean repeats, float attenuationDistance, Gauge gauge) {
        return null;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int entityIDorX, int y, int z) {
        switch (GuiTypes.values()[ID]) {
            case FREIGHT: {
                return new FreightContainer((IInventory)player.field_71071_by, (CarFreight)world.func_73045_a(entityIDorX));
            }
            case TANK: 
            case DIESEL_LOCOMOTIVE: {
                return new TankContainer((IInventory)player.field_71071_by, (FreightTank)world.func_73045_a(entityIDorX));
            }
            case TENDER: {
                return new TenderContainer((IInventory)player.field_71071_by, (Tender)world.func_73045_a(entityIDorX));
            }
            case STEAM_LOCOMOTIVE: {
                return new SteamLocomotiveContainer((IInventory)player.field_71071_by, (LocomotiveSteam)world.func_73045_a(entityIDorX));
            }
            case STEAM_HAMMER: {
                TileMultiblock te = TileMultiblock.get((IBlockAccess)world, new BlockPos(entityIDorX, y, z));
                if (te == null) {
                    return null;
                }
                return new SteamHammerContainer((IInventory)player.field_71071_by, te);
            }
        }
        return null;
    }

    public int getRenderDistance() {
        return 8;
    }

    public static double getServerTPS(World world, double sampleSize) {
        long[] ttl = world.func_73046_m().field_71311_j;
        sampleSize = Math.min(sampleSize, (double)ttl.length);
        double ttus = 0.0;
        int i = 0;
        while ((double)i < sampleSize) {
            ttus += (double)ttl[ttl.length - 1 - i] / sampleSize;
            ++i;
        }
        if (ttus == 0.0) {
            ttus = 0.01;
        }
        double ttms = ttus * 1.0E-6;
        return Math.min(1000.0 / ttms, 20.0);
    }

    public abstract void addPreview(int var1, TileRailPreview var2);

    static {
        entityClasses.add(LocomotiveSteam.class);
        entityClasses.add(LocomotiveDiesel.class);
        entityClasses.add(CarPassenger.class);
        entityClasses.add(CarFreight.class);
        entityClasses.add(CarTank.class);
        entityClasses.add(Tender.class);
        entityClasses.add(HandCar.class);
    }
}

