/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.proxy;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.proxy.ChunkPos;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkManager
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.OrderedLoadingCallback {
    private static final Map<Integer, ForgeChunkManager.Ticket> TICKETS = new HashMap<Integer, ForgeChunkManager.Ticket>();
    private static final Map<ChunkPos, Integer> CHUNK_MAP = new HashMap<ChunkPos, Integer>();

    public void init() {
        if (!ForgeChunkManager.getConfig().hasCategory("immersiverailroading")) {
            ForgeChunkManager.getConfig().get("immersiverailroading", "maximumChunksPerTicket", 1000000).setMinValue(0);
            ForgeChunkManager.getConfig().save();
        }
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)ImmersiveRailroading.instance, (ForgeChunkManager.LoadingCallback)this);
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> loaded_tickets, World world, int maxTicketCount) {
        return Collections.emptyList();
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        int dim = world.field_73011_w.getDimension();
        if (TICKETS.containsKey(dim)) {
            TICKETS.remove(dim);
        }
        if (tickets.size() == 1) {
            TICKETS.put(dim, tickets.get(0));
        }
    }

    private static ForgeChunkManager.Ticket ticketForWorld(World world) {
        int dim = world.field_73011_w.getDimension();
        if (!TICKETS.containsKey(dim)) {
            TICKETS.put(dim, ForgeChunkManager.requestTicket((Object)ImmersiveRailroading.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL));
        }
        return TICKETS.get(dim);
    }

    public static void flagEntityPos(World world, BlockPos inPos) {
        if (world.field_72995_K) {
            return;
        }
        ChunkPos pos = new ChunkPos(world, inPos);
        int currTicks = 0;
        if (CHUNK_MAP.containsKey(pos)) {
            currTicks = CHUNK_MAP.get(pos) + 1;
        } else {
            ImmersiveRailroading.debug("NEW CHUNK %s %s", pos.chunkX, pos.chunkZ);
        }
        CHUNK_MAP.put(pos, Math.max(100, Math.min(10, currTicks)));
    }

    public static void flagEntityPos(Entity entity) {
        ChunkManager.flagEntityPos(entity.func_130014_f_(), entity.func_180425_c());
    }

    public static void handleWorldTick(World world) {
        int dim = world.field_73011_w.getDimension();
        Set<ChunkPos> keys = CHUNK_MAP.keySet();
        HashSet<ChunkPos> loaded = new HashSet<ChunkPos>();
        HashSet<ChunkPos> unload = new HashSet<ChunkPos>();
        for (ChunkPos pos : keys) {
            if (pos.dim != dim) continue;
            int ticks = CHUNK_MAP.get(pos);
            if (ticks > 0) {
                loaded.add(pos);
                CHUNK_MAP.put(pos, ticks - 1);
                continue;
            }
            unload.add(pos);
        }
        for (ChunkPos pos : unload) {
            CHUNK_MAP.remove(pos);
        }
        ForgeChunkManager.Ticket ticket = ChunkManager.ticketForWorld(world);
        for (net.minecraft.util.math.ChunkPos chunk : ticket.getChunkList()) {
            boolean shouldChunkLoad = false;
            for (ChunkPos pos : loaded) {
                if (chunk.field_77276_a != pos.chunkX || chunk.field_77275_b != pos.chunkZ) continue;
                shouldChunkLoad = true;
                loaded.remove(pos);
                break;
            }
            if (shouldChunkLoad) continue;
            ImmersiveRailroading.debug("UNLOADED CHUNK %s %s", chunk.field_77276_a, chunk.field_77275_b);
            try {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (net.minecraft.util.math.ChunkPos)chunk);
            }
            catch (Exception ex) {
                ImmersiveRailroading.catching(ex);
            }
        }
        for (ChunkPos pos : loaded) {
            ImmersiveRailroading.debug("LOADED CHUNK %s %s", pos.chunkX, pos.chunkZ);
            try {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (net.minecraft.util.math.ChunkPos)new net.minecraft.util.math.ChunkPos(pos.chunkX, pos.chunkZ));
            }
            catch (Exception ex) {
                ImmersiveRailroading.catching(ex);
            }
        }
    }
}

