/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.net;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.util.BufferUtil;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PaintSyncPacket
implements IMessage {
    private int dimension;
    private int entityID;
    private String texture;

    public PaintSyncPacket() {
    }

    public PaintSyncPacket(EntityRollingStock mrs) {
        this.dimension = mrs.field_71093_bK;
        this.entityID = mrs.func_145782_y();
        this.texture = mrs.texture;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.texture != null);
        if (this.texture != null) {
            BufferUtil.writeString(buf, this.texture);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.entityID = buf.readInt();
        this.texture = buf.readBoolean() ? BufferUtil.readString(buf) : null;
    }

    public static class Handler
    implements IMessageHandler<PaintSyncPacket, IMessage> {
        public IMessage onMessage(PaintSyncPacket message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PaintSyncPacket message, MessageContext ctx) {
            EntityRollingStock entity = (EntityRollingStock)ImmersiveRailroading.proxy.getWorld(message.dimension).func_73045_a(message.entityID);
            if (entity == null) {
                return;
            }
            entity.texture = message.texture;
        }
    }
}

