/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.multiblock;

import cam72cam.immersiverailroading.util.OreHelper;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultiblockComponent {
    private final Function<IBlockState, Boolean> blockCheck;
    private final Function<ItemStack, Boolean> itemCheck;
    public final String name;
    protected final IBlockState def;

    public MultiblockComponent() {
        this.def = null;
        this.name = "none";
        this.blockCheck = target -> true;
        this.itemCheck = stack -> false;
    }

    public MultiblockComponent(OreHelper.OreAbstract name) {
        ItemStack stack = name.example();
        this.name = stack.func_82833_r();
        this.def = Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77960_j());
        this.blockCheck = target -> {
            Block block = target.func_177230_c();
            Item item = Item.func_150898_a((Block)block);
            int meta = block.func_176201_c(target);
            return name.matches(new ItemStack(item, 1, meta), false);
        };
        this.itemCheck = tstack -> name.matches((ItemStack)tstack, false);
    }

    public MultiblockComponent(Block block) {
        this.def = block.func_176223_P();
        this.name = block.func_149732_F();
        this.blockCheck = target -> target.func_177230_c() == block;
        this.itemCheck = stack -> Block.func_149634_a((Item)stack.func_77973_b()) == block;
    }

    public MultiblockComponent(IBlockState state, ItemStack stack) {
        this.def = state;
        this.name = stack.func_82833_r();
        this.blockCheck = target -> target.equals(state);
        this.itemCheck = tstack -> tstack.func_77969_a(stack);
    }

    public MultiblockComponent(Function<IBlockState, Boolean> blockCheck, Function<ItemStack, Boolean> itemCheck, IBlockState def, String name) {
        this.def = def;
        this.name = name;
        this.blockCheck = blockCheck;
        this.itemCheck = itemCheck;
    }

    public boolean valid(IBlockAccess world, BlockPos pos) {
        return this.blockCheck.apply(world.func_180495_p(pos));
    }

    public boolean place(World world, EntityPlayer player, BlockPos pos) {
        if (player.func_184812_l_()) {
            if (this.def != null) {
                world.func_175656_a(pos, this.def);
                world.func_184138_a(pos, this.def, this.def, 3);
            }
            return true;
        }
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            ItemStack stack = player.field_71071_by.func_70301_a(slot);
            if (!this.itemCheck.apply(stack).booleanValue()) continue;
            int count = stack.func_190916_E();
            ItemStack backup = player.func_184586_b(EnumHand.MAIN_HAND).func_77946_l();
            player.func_184611_a(EnumHand.MAIN_HAND, stack.func_77946_l());
            EnumActionResult result = stack.func_77973_b().func_180614_a(player, world, pos, EnumHand.MAIN_HAND, EnumFacing.DOWN, 0.5f, 0.0f, 0.5f);
            player.func_184611_a(EnumHand.MAIN_HAND, backup);
            if (result != EnumActionResult.SUCCESS) continue;
            if (player.field_71071_by.func_70301_a(slot).func_190916_E() == count) {
                stack.func_190920_e(stack.func_190916_E() - 1);
                player.field_71071_by.func_70299_a(slot, stack);
            }
            return true;
        }
        return false;
    }
}

