/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items.nbt;

import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class RailSettings {
    public final Gauge gauge;
    public final TrackItems type;
    public final int length;
    public final int quarters;
    public final TrackPositionType posType;
    public final TrackDirection direction;
    public final ItemStack railBed;
    public final ItemStack railBedFill;
    public final boolean isPreview;
    public final boolean isGradeCrossing;

    public RailSettings(Gauge gauge, TrackItems type, int length, int quarters, TrackPositionType posType, TrackDirection direction, ItemStack railBed, ItemStack railBedFill, boolean isPreview, boolean isGradeCrossing) {
        this.gauge = gauge;
        this.type = type;
        this.length = length;
        this.quarters = quarters;
        this.posType = posType;
        this.direction = direction;
        this.railBed = railBed;
        this.railBedFill = railBedFill;
        this.isPreview = isPreview;
        this.isGradeCrossing = isGradeCrossing;
    }

    public RailSettings(NBTTagCompound nbt) {
        if (nbt.func_74764_b("gauge")) {
            this.gauge = Gauge.from(nbt.func_74769_h("gauge"));
            this.type = TrackItems.values()[nbt.func_74762_e("type")];
            this.length = nbt.func_74762_e("length");
            this.quarters = nbt.func_74764_b("quarters") ? nbt.func_74762_e("quarters") : 4;
            this.posType = TrackPositionType.values()[nbt.func_74762_e("pos_type")];
            this.direction = TrackDirection.values()[nbt.func_74762_e("direction")];
            this.railBed = new ItemStack(nbt.func_74775_l("bedItem"));
            this.railBedFill = new ItemStack(nbt.func_74775_l("bedFill"));
            this.isPreview = nbt.func_74767_n("isPreview");
            this.isGradeCrossing = nbt.func_74767_n("isGradeCrossing");
        } else {
            this.gauge = Gauge.from(1.435);
            this.type = TrackItems.STRAIGHT;
            this.length = 10;
            this.quarters = 4;
            this.posType = TrackPositionType.FIXED;
            this.direction = TrackDirection.NONE;
            this.railBed = ItemStack.field_190927_a;
            this.railBedFill = ItemStack.field_190927_a;
            this.isPreview = false;
            this.isGradeCrossing = false;
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("gauge", this.gauge.value());
        nbt.func_74768_a("type", this.type.ordinal());
        nbt.func_74768_a("length", this.length);
        nbt.func_74768_a("quarters", this.quarters);
        nbt.func_74768_a("pos_type", this.posType.ordinal());
        nbt.func_74768_a("direction", this.direction.ordinal());
        nbt.func_74782_a("bedItem", (NBTBase)this.railBed.serializeNBT());
        nbt.func_74782_a("bedFill", (NBTBase)this.railBedFill.serializeNBT());
        nbt.func_74757_a("isPreview", this.isPreview);
        nbt.func_74757_a("isGradeCrossing", this.isGradeCrossing);
        return nbt;
    }

    public RailSettings withLength(int length) {
        return new RailSettings(this.gauge, this.type, length, this.quarters, this.posType, this.direction, this.railBed, this.railBedFill, this.isPreview, this.isGradeCrossing);
    }

    public RailSettings withType(TrackItems type) {
        return new RailSettings(this.gauge, type, this.length, this.quarters, this.posType, this.direction, this.railBed, this.railBedFill, this.isPreview, this.isGradeCrossing);
    }
}

