/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import cam72cam.immersiverailroading.gui.CraftPicker;
import cam72cam.immersiverailroading.gui.GUIHelpers;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.items.nbt.ItemRawCast;
import cam72cam.immersiverailroading.library.CraftingMachineMode;
import cam72cam.immersiverailroading.library.CraftingType;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.multiblock.CastingMultiblock;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.util.ItemCastingCost;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

public class CastingGUI
extends GuiScreen {
    public static final ResourceLocation CASTING_GUI_TEXTURE = new ResourceLocation("immersiverailroading:gui/casting_gui.png");
    private GuiButton gaugeButton;
    private Gauge gauge;
    private GuiButton pickerButton;
    private CraftPicker picker;
    private GuiButton singleCastButton;
    private GuiButton repeatCastButton;
    private TileMultiblock tile;
    private ItemStack currentItem;

    public CastingGUI(TileMultiblock te) {
        this.tile = te;
        this.currentItem = ((CastingMultiblock.CastingInstance)te.getMultiblock()).getCraftItem();
        this.gauge = ItemGauge.get(this.currentItem);
        this.picker = new CraftPicker(this.currentItem, CraftingType.CASTING, item -> {
            this.field_146297_k.func_147108_a((GuiScreen)this);
            if (item != null) {
                this.currentItem = item;
                this.updatePickerButton();
                this.sendItemPacket();
            }
        });
    }

    private void updatePickerButton() {
        this.pickerButton.field_146126_j = this.currentItem.func_190926_b() ? GuiText.SELECTOR_TYPE.toString("") : this.currentItem.func_82833_r();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        int buttonID = 0;
        this.pickerButton = new GuiButton(buttonID++, this.field_146294_l / 2 - 100, this.field_146295_m / 4 - 20 - 10, GuiText.SELECTOR_TYPE.toString(""));
        this.updatePickerButton();
        this.field_146292_n.add(this.pickerButton);
        this.gaugeButton = new GuiButton(buttonID++, this.field_146294_l / 2, this.field_146295_m / 4 - 10, 100, 20, GuiText.SELECTOR_GAUGE.toString(this.gauge));
        this.field_146292_n.add(this.gaugeButton);
        this.singleCastButton = new GuiButton(buttonID++, this.field_146294_l / 2, this.field_146295_m / 4 + 20 - 10, 100, 20, GuiText.SELECTOR_CAST_SINGLE.toString());
        this.field_146292_n.add(this.singleCastButton);
        this.repeatCastButton = new GuiButton(buttonID++, this.field_146294_l / 2, this.field_146295_m / 4 + 40 - 10, 100, 20, GuiText.SELECTOR_CAST_REPEAT.toString());
        this.field_146292_n.add(this.repeatCastButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.singleCastButton.packedFGColour = 0;
        this.repeatCastButton.packedFGColour = 0;
        switch (this.tile.getCraftMode()) {
            case SINGLE: {
                this.singleCastButton.packedFGColour = 0xCC4334;
                break;
            }
            case REPEAT: {
                this.repeatCastButton.packedFGColour = 0xCC4334;
                break;
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double fluidPercent = ((CastingMultiblock.CastingInstance)this.tile.getMultiblock()).getSteelLevel();
        int progress = this.tile.getCraftProgress();
        float cost = ItemCastingCost.getCastCost(this.currentItem);
        if (cost == -999.0f) {
            cost = 0.0f;
        }
        this.field_146297_k.func_110434_K().func_110577_a(CASTING_GUI_TEXTURE);
        GUIHelpers.texturedRect(this.field_146294_l / 2 - 100, this.field_146295_m / 4, 200.0, 100.0);
        GUIHelpers.drawTankBlock((double)(this.field_146294_l / 2) - 94.5, this.field_146295_m / 4 + 3, 56.7, 60.0, FluidRegistry.LAVA, (float)fluidPercent, false, -1711571435);
        GUIHelpers.drawTankBlock((double)(this.field_146294_l / 2) - 28.5, this.field_146295_m / 4 + 67, 125.2, 30.0, FluidRegistry.LAVA, (float)progress / cost, false, -1718871783);
        String fillStr = String.format("%s/%s", (int)(fluidPercent * 810.0), 810);
        String castStr = String.format("%s/%s", progress, (int)cost);
        this.func_73732_a(this.field_146289_q, fillStr, this.field_146294_l / 2 - 94 + 27, this.field_146295_m / 4 + 3 + 25, 0xE0E0E0);
        this.func_73732_a(this.field_146289_q, castStr, this.field_146294_l / 2 - 28 + 60, this.field_146295_m / 4 + 67 + 10, 0xE0E0E0);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.gaugeButton) {
            this.gauge = this.gauge.next();
            this.gaugeButton.field_146126_j = GuiText.SELECTOR_GAUGE.toString(this.gauge);
            this.sendItemPacket();
        }
        if (button == this.pickerButton) {
            this.field_146297_k.func_147108_a((GuiScreen)this.picker);
        }
        if (button == this.singleCastButton) {
            if (this.tile.getCraftMode() != CraftingMachineMode.SINGLE) {
                this.tile.setCraftMode(CraftingMachineMode.SINGLE);
            } else {
                this.tile.setCraftMode(CraftingMachineMode.STOPPED);
            }
        }
        if (button == this.repeatCastButton) {
            if (this.tile.getCraftMode() != CraftingMachineMode.REPEAT) {
                this.tile.setCraftMode(CraftingMachineMode.REPEAT);
            } else {
                this.tile.setCraftMode(CraftingMachineMode.STOPPED);
            }
        }
    }

    private void sendItemPacket() {
        ItemGauge.set(this.currentItem, this.gauge);
        this.currentItem.func_190920_e(1);
        ItemRawCast.set(this.currentItem, true);
        this.tile.setCraftItem(this.currentItem);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || keyCode == 28 || keyCode == 156) {
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }
}

