/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntitySmokeParticle;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.inventory.SlotFilter;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.library.ValveGearType;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.registry.LocomotiveSteamDefinition;
import cam72cam.immersiverailroading.registry.Quilling;
import cam72cam.immersiverailroading.sound.ISound;
import cam72cam.immersiverailroading.util.BurnUtil;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.immersiverailroading.util.LiquidUtil;
import cam72cam.immersiverailroading.util.VecUtil;
import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class LocomotiveSteam
extends Locomotive {
    private static DataParameter<Float> BOILER_PRESSURE = EntityDataManager.func_187226_a(LocomotiveSteam.class, (DataSerializer)DataSerializers.field_187193_c);
    private static DataParameter<Float> BOILER_TEMPERATURE = EntityDataManager.func_187226_a(LocomotiveSteam.class, (DataSerializer)DataSerializers.field_187193_c);
    private static DataParameter<Boolean> PRESSURE_VALVE = EntityDataManager.func_187226_a(LocomotiveSteam.class, (DataSerializer)DataSerializers.field_187198_h);
    private static DataParameter<NBTTagCompound> BURN_TIME = EntityDataManager.func_187226_a(LocomotiveSteam.class, (DataSerializer)DataSerializers.field_192734_n);
    private static DataParameter<NBTTagCompound> BURN_MAX = EntityDataManager.func_187226_a(LocomotiveSteam.class, (DataSerializer)DataSerializers.field_192734_n);
    private double driverDiameter;
    private Map<String, Boolean> phaseOn = new HashMap<String, Boolean>();
    private List<ISound> sndCache = new ArrayList<ISound>();
    private int sndCacheId = 0;
    private ISound whistle;
    private List<ISound> chimes = new ArrayList<ISound>();
    private float pullString = 0.0f;
    private float soundDampener = 0.0f;
    private ISound idle;
    private ISound pressure;
    private int tickMod = 0;

    public LocomotiveSteam(World world) {
        this(world, null);
    }

    public LocomotiveSteam(World world, String defID) {
        super(world, defID);
        this.func_184212_Q().func_187214_a(BOILER_PRESSURE, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(BOILER_TEMPERATURE, (Object)Float.valueOf(this.ambientTemperature()));
        this.func_184212_Q().func_187214_a(PRESSURE_VALVE, (Object)false);
        this.func_184212_Q().func_187214_a(BURN_TIME, (Object)new NBTTagCompound());
        this.func_184212_Q().func_187214_a(BURN_MAX, (Object)new NBTTagCompound());
    }

    @Override
    public LocomotiveSteamDefinition getDefinition() {
        return super.getDefinition(LocomotiveSteamDefinition.class);
    }

    @Override
    public GuiTypes guiType() {
        return GuiTypes.STEAM_LOCOMOTIVE;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74776_a("boiler_temperature", this.getBoilerTemperature());
        nbttagcompound.func_74776_a("boiler_psi", this.getBoilerPressure());
        nbttagcompound.func_74782_a("burn_time", (NBTBase)this.field_70180_af.func_187225_a(BURN_TIME));
        nbttagcompound.func_74782_a("burn_max", (NBTBase)this.field_70180_af.func_187225_a(BURN_MAX));
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setBoilerTemperature(nbttagcompound.func_74760_g("boiler_temperature"));
        this.setBoilerPressure(nbttagcompound.func_74760_g("boiler_psi"));
        this.field_70180_af.func_187227_b(BURN_TIME, (Object)((NBTTagCompound)nbttagcompound.func_74781_a("burn_time")));
        this.field_70180_af.func_187227_b(BURN_MAX, (Object)((NBTTagCompound)nbttagcompound.func_74781_a("burn_max")));
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        List<RenderComponent> driving = this.getDefinition().getComponents(RenderComponentType.WHEEL_DRIVER_X, this.gauge);
        if (driving != null) {
            for (RenderComponent driver : driving) {
                this.driverDiameter = Math.max(this.driverDiameter, driver.height());
            }
        }
        if ((driving = this.getDefinition().getComponents(RenderComponentType.WHEEL_DRIVER_REAR_X, this.gauge)) != null) {
            for (RenderComponent driver : driving) {
                this.driverDiameter = Math.max(this.driverDiameter, driver.height());
            }
        }
    }

    public float getBoilerTemperature() {
        return ((Float)this.field_70180_af.func_187225_a(BOILER_TEMPERATURE)).floatValue();
    }

    private void setBoilerTemperature(float temp) {
        this.field_70180_af.func_187227_b(BOILER_TEMPERATURE, (Object)Float.valueOf(temp));
    }

    public float getBoilerPressure() {
        return ((Float)this.field_70180_af.func_187225_a(BOILER_PRESSURE)).floatValue();
    }

    private void setBoilerPressure(float temp) {
        this.field_70180_af.func_187227_b(BOILER_PRESSURE, (Object)Float.valueOf(temp));
    }

    private NBTTagCompound mapToNBT(Map<Integer, Integer> map) {
        NBTTagCompound data = new NBTTagCompound();
        for (Integer slot : map.keySet()) {
            data.func_74768_a("" + slot, map.get(slot).intValue());
        }
        return data;
    }

    private Map<Integer, Integer> NBTtoMap(NBTTagCompound nbt) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (String key : nbt.func_150296_c()) {
            map.put(Integer.parseInt(key), nbt.func_74762_e(key));
        }
        return map;
    }

    public Map<Integer, Integer> getBurnTime() {
        return this.NBTtoMap((NBTTagCompound)this.field_70180_af.func_187225_a(BURN_TIME));
    }

    private void setBurnTime(Map<Integer, Integer> burnTime) {
        this.field_70180_af.func_187227_b(BURN_TIME, (Object)this.mapToNBT(burnTime));
    }

    public Map<Integer, Integer> getBurnMax() {
        return this.NBTtoMap((NBTTagCompound)this.field_70180_af.func_187225_a(BURN_MAX));
    }

    private void setBurnMax(Map<Integer, Integer> burnMax) {
        this.field_70180_af.func_187227_b(BURN_MAX, (Object)this.mapToNBT(burnMax));
    }

    @Override
    protected int getAvailableHP() {
        if (!Config.isFuelRequired(this.gauge)) {
            return this.getDefinition().getHorsePower(this.gauge);
        }
        return (int)((double)this.getDefinition().getHorsePower(this.gauge) * Math.pow(this.getBoilerPressure() / (float)this.getDefinition().getMaxPSI(this.gauge), 3.0));
    }

    @Override
    public void onDissassemble() {
        super.onDissassemble();
        this.setBoilerTemperature(this.ambientTemperature());
        this.setBoilerPressure(0.0f);
        Map<Integer, Integer> burnTime = this.getBurnTime();
        for (Integer slot : burnTime.keySet()) {
            burnTime.put(slot, 0);
        }
        this.setBurnTime(burnTime);
    }

    private double getPhase(int spikes, float offsetDegrees, double perc) {
        if (this.driverDiameter == 0.0) {
            return 0.0;
        }
        double circumference = this.driverDiameter * Math.PI;
        double skewDistance = (double)this.distanceTraveled - this.getCurrentSpeed().minecraft() * perc;
        double phase = skewDistance % circumference / circumference;
        phase = Math.abs(Math.cos(phase * Math.PI * (double)spikes + Math.toRadians(offsetDegrees)));
        return phase;
    }

    private double getPhase(int spikes, float offsetDegrees) {
        if (this.driverDiameter == 0.0) {
            return 0.0;
        }
        double circumference = this.driverDiameter * Math.PI;
        double phase = (double)this.distanceTraveled % circumference / circumference;
        phase = Math.abs(Math.cos(phase * Math.PI * (double)spikes + Math.toRadians(offsetDegrees)));
        return phase;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void func_70071_h_() {
        float waterUsed;
        int burningSlots;
        Boolean changedBurnMax;
        Boolean changedBurnTime;
        Map<Integer, Integer> burnMax;
        Map<Integer, Integer> burnTime;
        float waterLevelMB;
        float f;
        float boilerTemperature;
        block100: {
            void var10_56;
            super.func_70071_h_();
            if (this.field_70173_aa < 2) {
                return;
            }
            if (this.field_70170_p.field_72995_K) {
                List<RenderComponent> steams;
                List<RenderComponent> whistles;
                if (ConfigSound.soundEnabled) {
                    if (this.sndCache.size() == 0) {
                        this.whistle = ImmersiveRailroading.proxy.newSound(this.getDefinition().whistle, false, 150.0f, this.soundGauge());
                        this.whistle.setPitch(1.0f);
                        if (this.getDefinition().quill != null) {
                            for (Quilling.Chime chime : this.getDefinition().quill.chimes) {
                                this.chimes.add(ImmersiveRailroading.proxy.newSound(chime.sample, true, 150.0f, this.soundGauge()));
                            }
                        }
                        for (int i = 0; i < 32; ++i) {
                            this.sndCache.add(ImmersiveRailroading.proxy.newSound(this.getDefinition().chuff, false, 80.0f, this.soundGauge()));
                        }
                        this.idle = ImmersiveRailroading.proxy.newSound(this.getDefinition().idle, true, 40.0f, this.soundGauge());
                        this.idle.setVolume(0.1f);
                        this.pressure = ImmersiveRailroading.proxy.newSound(this.getDefinition().pressure, true, 40.0f, this.soundGauge());
                        this.pressure.setVolume(0.3f);
                    }
                    if ((Integer)this.func_184212_Q().func_187225_a(HORN) < 1) {
                        this.pullString = 0.0f;
                        this.soundDampener = 0.0f;
                        for (ISound iSound : this.chimes) {
                            if (!iSound.isPlaying()) continue;
                            iSound.stop();
                        }
                    } else if (this.getBoilerPressure() > 0.0f || !Config.isFuelRequired(this.gauge)) {
                        if (this.getDefinition().quill == null) {
                            if (!this.whistle.isPlaying()) {
                                this.whistle.play(this.func_174791_d());
                            }
                        } else {
                            float maxDelta = 0.05f;
                            float f2 = 0.0f;
                            if ((Integer)this.func_184212_Q().func_187225_a(HORN) > 5) {
                                if ((double)this.soundDampener < 0.4) {
                                    this.soundDampener = 0.4f;
                                }
                                if (this.soundDampener < 1.0f) {
                                    this.soundDampener = (float)((double)this.soundDampener + 0.1);
                                }
                                if (((Optional)this.func_184212_Q().func_187225_a(HORN_PLAYER)).isPresent()) {
                                    for (Entity pass : this.func_184188_bt()) {
                                        if (!pass.getPersistentID().equals(((Optional)this.func_184212_Q().func_187225_a(HORN_PLAYER)).get())) continue;
                                        float newString = (pass.field_70125_A + 90.0f) / 180.0f;
                                        f2 = newString - this.pullString;
                                    }
                                } else {
                                    f2 = (float)this.getDefinition().quill.maxPull - this.pullString;
                                }
                            } else {
                                if (this.soundDampener > 0.0f) {
                                    this.soundDampener = (float)((double)this.soundDampener - 0.07);
                                }
                                f2 = -this.pullString;
                            }
                            this.pullString = this.pullString == 0.0f ? (float)((double)this.pullString + (double)f2 * 0.55) : (this.pullString += Math.max(Math.min(f2, maxDelta), -maxDelta));
                            this.pullString = Math.min(this.pullString, (float)this.getDefinition().quill.maxPull);
                            for (int i = 0; i < this.getDefinition().quill.chimes.size(); ++i) {
                                ISound sound = this.chimes.get(i);
                                Quilling.Chime chime = this.getDefinition().quill.chimes.get(i);
                                double perc = this.pullString;
                                perc = Math.min(perc, chime.pull_end);
                                perc -= chime.pull_start;
                                if ((perc /= chime.pull_end - chime.pull_start) > 0.0) {
                                    double pitch = (chime.pitch_end - chime.pitch_start) * perc + chime.pitch_start;
                                    sound.setPitch((float)pitch);
                                    sound.setVolume((float)(perc * (double)this.soundDampener));
                                    if (sound.isPlaying()) continue;
                                    sound.play(this.func_174791_d());
                                    continue;
                                }
                                if (!sound.isPlaying()) continue;
                                sound.stop();
                            }
                        }
                    }
                    if (this.getBoilerTemperature() > this.ambientTemperature() + 5.0f) {
                        if (!this.idle.isPlaying()) {
                            this.idle.play(this.func_174791_d());
                        }
                    } else if (this.idle.isPlaying()) {
                        this.idle.stop();
                    }
                }
                Vec3d fakeMotion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                List<RenderComponent> smokes = this.getDefinition().getComponents(RenderComponentType.PARTICLE_CHIMNEY_X, this.gauge);
                if (smokes != null && ConfigGraphics.particlesEnabled) {
                    double phase = this.getPhase(4, 0.0f);
                    for (RenderComponent smoke : smokes) {
                        Vec3d particlePos = this.func_174791_d().func_178787_e(VecUtil.rotateWrongYaw(smoke.center(), this.field_70177_z + 180.0f));
                        particlePos = particlePos.func_178788_d(fakeMotion);
                        if (this.field_70173_aa % 1 != 0) continue;
                        float darken = 0.0f;
                        float thickness = Math.abs(this.getThrottle()) / 2.0f;
                        for (int i : this.getBurnTime().values()) {
                            darken += i >= 1 ? 1.0f : 0.0f;
                        }
                        if (darken == 0.0f && Config.isFuelRequired(this.gauge)) break;
                        darken = (float)((double)darken / ((double)this.getInventorySize() - 2.0));
                        darken = (float)((double)darken * 0.5);
                        double d = Math.min(1.0, Math.max(0.2, Math.abs(this.getCurrentSpeed().minecraft()) * 2.0));
                        int lifespan = (int)((double)(200.0f * (1.0f + Math.abs(this.getThrottle()))) * d * this.gauge.scale());
                        float verticalSpeed = 0.5f;
                        double size = smoke.width() * (0.8 + d);
                        if (phase != 0.0 && (double)Math.abs(this.getThrottle()) > 0.01 && Math.abs(this.getCurrentSpeed().metric()) / this.gauge.scale() < 30.0) {
                            double phaseSpike = Math.pow(phase, 8.0);
                            size *= 1.0 + phaseSpike * 1.5;
                            verticalSpeed = (float)((double)verticalSpeed * (1.0 + phaseSpike / 2.0));
                        }
                        particlePos = particlePos.func_178788_d(fakeMotion);
                        EntitySmokeParticle sp = new EntitySmokeParticle(this.field_70170_p, lifespan, darken, thickness, size);
                        sp.func_70107_b(particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                        sp.func_70016_h(fakeMotion.field_72450_a, fakeMotion.field_72448_b + (double)verticalSpeed, fakeMotion.field_72449_c);
                        this.field_70170_p.func_72838_d((Entity)sp);
                    }
                }
                if ((whistles = this.getDefinition().getComponents(RenderComponentType.WHISTLE, this.gauge)) != null && ((Integer)this.func_184212_Q().func_187225_a(HORN) != 0 || this.whistle != null && this.whistle.isPlaying()) && (this.getBoilerPressure() > 0.0f || !Config.isFuelRequired(this.gauge))) {
                    for (RenderComponent whistle : whistles) {
                        Vec3d particlePos = this.func_174791_d().func_178787_e(VecUtil.rotateWrongYaw(whistle.center(), this.field_70177_z + 180.0f));
                        particlePos = particlePos.func_178788_d(fakeMotion);
                        float darken = 0.0f;
                        float f3 = 1.0f;
                        double smokeMod = Math.min(1.0, Math.max(0.2, Math.abs(this.getCurrentSpeed().minecraft()) * 2.0));
                        int lifespan = (int)(40.0 * (1.0 + smokeMod * this.gauge.scale()));
                        float verticalSpeed = 0.8f;
                        double size = 0.3 * (0.8 + smokeMod);
                        particlePos = particlePos.func_178788_d(fakeMotion);
                        EntitySmokeParticle sp = new EntitySmokeParticle(this.field_70170_p, lifespan, darken, f3, size);
                        sp.func_70107_b(particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                        sp.func_70016_h(fakeMotion.field_72450_a, fakeMotion.field_72448_b + (double)verticalSpeed, fakeMotion.field_72449_c);
                        this.field_70170_p.func_72838_d((Entity)sp);
                    }
                }
                List<RenderComponent> pistons = this.getDefinition().getComponents(RenderComponentType.PISTON_ROD_SIDE, this.gauge);
                double csm = Math.abs(this.getCurrentSpeed().metric()) / this.gauge.scale();
                if (pistons != null && (this.getBoilerPressure() > 0.0f || !Config.isFuelRequired(this.gauge))) {
                    block26: for (RenderComponent renderComponent : pistons) {
                        double tickDelt;
                        float phaseOffset = 0.0f;
                        switch (renderComponent.side) {
                            case "LEFT": {
                                tickDelt = 2.0;
                                phaseOffset = 135.0f;
                                break;
                            }
                            case "RIGHT": {
                                tickDelt = 2.0;
                                phaseOffset = this.getDefinition().getValveGear() != ValveGearType.TRI_WALSCHAERTS ? 45.0f : -105.0f;
                                break;
                            }
                            case "CENTER": {
                                tickDelt = 2.0;
                                phaseOffset = 15.0f;
                                break;
                            }
                            case "LEFT_FRONT": {
                                tickDelt = 1.0;
                                phaseOffset = 135.0f;
                                break;
                            }
                            case "RIGHT_FRONT": {
                                tickDelt = 1.0;
                                phaseOffset = 45.0f;
                                break;
                            }
                            case "LEFT_REAR": {
                                tickDelt = 1.0;
                                phaseOffset = 90.0f;
                                break;
                            }
                            case "RIGHT_REAR": {
                                tickDelt = 1.0;
                                phaseOffset = 0.0f;
                                break;
                            }
                            default: {
                                continue block26;
                            }
                        }
                        double phase = this.getPhase(2, phaseOffset);
                        double phaseSpike = Math.pow(phase, 4.0);
                        if (phaseSpike >= 0.6 && csm > 0.1 && csm < 20.0 && ConfigGraphics.particlesEnabled) {
                            Vec3d particlePos = this.func_174791_d().func_178787_e(VecUtil.rotateWrongYaw(renderComponent.min(), this.field_70177_z + 180.0f));
                            EntitySmokeParticle sp = new EntitySmokeParticle(this.field_70170_p, 80, 0.0f, 0.6f, 0.2);
                            sp.func_70107_b(particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                            double accell = 0.3 * this.gauge.scale();
                            if (renderComponent.side.contains("LEFT")) {
                                accell = -accell;
                            }
                            if (renderComponent.side.contains("CENTER")) {
                                accell = 0.0;
                            }
                            Vec3d sideMotion = fakeMotion.func_178787_e(VecUtil.fromWrongYaw(accell, this.field_70177_z + 90.0f));
                            sp.func_70016_h(sideMotion.field_72450_a, sideMotion.field_72448_b + 0.01, sideMotion.field_72449_c);
                            this.field_70170_p.func_72838_d((Entity)sp);
                        }
                        if (!ConfigSound.soundEnabled) continue;
                        String key = renderComponent.side;
                        if (!this.phaseOn.containsKey(key)) {
                            this.phaseOn.put(key, false);
                        }
                        for (int i = 0; i < 10; ++i) {
                            phase = this.getPhase(2, phaseOffset + 45.0f, 1.0 - (double)i / 10.0);
                            if (!this.phaseOn.get(key).booleanValue()) {
                                if (!(phase > 0.5)) continue;
                                double speed = Math.abs(this.getCurrentSpeed().minecraft());
                                double maxSpeed = Math.abs(this.getDefinition().getMaxSpeed(this.gauge).minecraft());
                                float volume = (float)Math.max(1.0 - speed / maxSpeed, 0.3) * Math.max(0.3f, Math.abs(this.getThrottle()));
                                volume = (float)Math.sqrt(volume);
                                double fraction = 3.0;
                                float pitch = 0.8f + (float)(speed / maxSpeed / fraction);
                                float delta = (float)(8 - this.tickMod) / 200.0f;
                                ISound snd = this.sndCache.get(this.sndCacheId);
                                snd.setPitch(pitch + delta);
                                snd.setVolume(volume + delta);
                                snd.play(this.func_174791_d());
                                ++this.sndCacheId;
                                this.sndCacheId %= this.sndCache.size();
                                this.phaseOn.put(key, true);
                                this.tickMod = (int)((double)this.tickMod + tickDelt);
                                if (this.tickMod <= 8) continue;
                                this.tickMod = 0;
                                continue;
                            }
                            if (!(phase < 0.5)) continue;
                            this.phaseOn.put(key, false);
                        }
                    }
                }
                if ((steams = this.getDefinition().getComponents(RenderComponentType.PRESSURE_VALVE_X, this.gauge)) != null && ((Boolean)this.func_184212_Q().func_187225_a(PRESSURE_VALVE)).booleanValue() && Config.isFuelRequired(this.gauge)) {
                    if (ConfigSound.soundEnabled && ConfigSound.soundPressureValve && !this.pressure.isPlaying()) {
                        this.pressure.play(this.func_174791_d());
                    }
                    if (ConfigGraphics.particlesEnabled) {
                        for (RenderComponent steam : steams) {
                            Vec3d particlePos = this.func_174791_d().func_178787_e(VecUtil.rotateWrongYaw(steam.center(), this.field_70177_z + 180.0f));
                            particlePos = particlePos.func_178788_d(fakeMotion);
                            EntitySmokeParticle sp = new EntitySmokeParticle(this.field_70170_p, 40, 0.0f, 0.2f, steam.width());
                            sp.func_70107_b(particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                            sp.func_70016_h(fakeMotion.field_72450_a, fakeMotion.field_72448_b + 0.2 * this.gauge.scale(), fakeMotion.field_72449_c);
                            this.field_70170_p.func_72838_d((Entity)sp);
                        }
                    }
                } else if (ConfigSound.soundEnabled && this.pressure.isPlaying()) {
                    this.pressure.stop();
                }
                if (ConfigSound.soundEnabled) {
                    void var10_54;
                    if (this.whistle.isPlaying()) {
                        this.whistle.setPosition(this.func_174791_d());
                        this.whistle.setVelocity(this.getVelocity());
                        this.whistle.update();
                    }
                    for (ISound chime : this.chimes) {
                        if (!chime.isPlaying()) continue;
                        chime.setPosition(this.func_174791_d());
                        chime.setVelocity(this.getVelocity());
                        chime.update();
                    }
                    if (this.idle.isPlaying()) {
                        this.idle.setPosition(this.func_174791_d());
                        this.idle.setVelocity(this.getVelocity());
                        this.idle.update();
                    }
                    if (this.pressure.isPlaying()) {
                        this.pressure.setPosition(this.func_174791_d());
                        this.pressure.setVelocity(this.getVelocity());
                        this.pressure.update();
                    }
                    boolean bl = false;
                    while (var10_54 < this.sndCache.size()) {
                        ISound snd = this.sndCache.get((int)var10_54);
                        if (snd.isPlaying()) {
                            snd.setPosition(this.func_174791_d());
                            snd.setVelocity(this.getVelocity());
                            snd.update();
                        }
                        ++var10_54;
                    }
                }
                return;
            }
            if (!this.isBuilt()) {
                return;
            }
            if (this.getCoupled(EntityCoupleableRollingStock.CouplerType.BACK) instanceof Tender) {
                Tender tender = (Tender)this.getCoupled(EntityCoupleableRollingStock.CouplerType.BACK);
                int n = 10;
                if (this.getTankCapacity().MilliBuckets() - this.getServerLiquidAmount() >= 10) {
                    FluidUtil.tryFluidTransfer((IFluidHandler)this.theTank, (IFluidHandler)tender.theTank, (int)n, (boolean)true);
                }
                if (this.field_70173_aa % 20 == 0) {
                    for (int slot = 0; slot < this.cargoItems.getSlots() - 2; ++slot) {
                        if (BurnUtil.getBurnTime(this.cargoItems.getStackInSlot(slot)) == 0) continue;
                        for (int tenderSlot = 0; tenderSlot < tender.cargoItems.getSlots(); ++tenderSlot) {
                            if (!this.cargoItems.getStackInSlot(slot).func_77969_a(tender.cargoItems.getStackInSlot(tenderSlot)) || this.cargoItems.getStackInSlot(slot).func_77976_d() <= this.cargoItems.getStackInSlot(slot).func_190916_E()) continue;
                            ItemStack extracted = tender.cargoItems.extractItem(tenderSlot, 1, false);
                            this.cargoItems.insertItem(slot, extracted, false);
                        }
                    }
                }
            }
            boilerTemperature = this.getBoilerTemperature();
            f = this.getBoilerPressure();
            waterLevelMB = this.getLiquidAmount();
            burnTime = this.getBurnTime();
            burnMax = this.getBurnMax();
            changedBurnTime = false;
            changedBurnMax = false;
            burningSlots = 0;
            waterUsed = 0.0f;
            if (this.getLiquidAmount() <= 0) break block100;
            boolean bl = false;
            while (var10_56 < this.cargoItems.getSlots() - 2) {
                block102: {
                    block103: {
                        int remainingTime;
                        block101: {
                            int n = remainingTime = burnTime.containsKey((int)var10_56) ? burnTime.get((int)var10_56) : 0;
                            if (remainingTime > 0) break block101;
                            ItemStack stack = this.cargoItems.getStackInSlot((int)var10_56);
                            if (stack.func_190916_E() <= 0 || !TileEntityFurnace.func_145954_b((ItemStack)stack)) break block102;
                            remainingTime = (int)((double)(BurnUtil.getBurnTime(stack) * 1) / this.gauge.scale() * ((double)Config.ConfigBalance.locoSteamFuelEfficiency / 100.0));
                            burnTime.put((int)var10_56, remainingTime);
                            burnMax.put((int)var10_56, remainingTime);
                            stack.func_190920_e(stack.func_190916_E() - 1);
                            this.cargoItems.setStackInSlot((int)var10_56, stack);
                            changedBurnMax = true;
                            break block103;
                        }
                        burnTime.put((int)var10_56, remainingTime - 1);
                    }
                    changedBurnTime = true;
                    ++burningSlots;
                }
                ++var10_56;
            }
        }
        double d = 0.0;
        if (burningSlots != 0 && this.getLiquidAmount() > 0) {
            d += (double)burningSlots * this.coalEnergyKCalTick();
        }
        double boilerVolume = this.getTankCapacity().Buckets();
        double boilerEdgeM = Math.pow(boilerVolume, 0.3333333333333333);
        double boilerAreaM = 6.0 * Math.pow(boilerEdgeM, 2.0);
        if (boilerTemperature > 0.0f) {
            double radiatedKwHr = Math.pow(boilerTemperature / 10.0f, 2.0) / 100.0 * boilerAreaM * 2.0;
            double radiatedKCalHr = radiatedKwHr * 859.85;
            double radiatedKCalTick = radiatedKCalHr / 60.0 / 60.0 / 20.0 * (double)Config.ConfigBalance.locoHeatTimeScale;
            d -= radiatedKCalTick / 1000.0;
        }
        if (d != 0.0) {
            boilerTemperature = (float)((double)boilerTemperature + d / (double)((waterLevelMB + 1.0f) / 1000.0f));
        }
        if (boilerTemperature > 100.0f) {
            float heatTransfer = boilerTemperature - 100.0f;
            f += heatTransfer;
            if (this.getPercentLiquidFull() > 25) {
                boilerTemperature -= heatTransfer;
            }
            int maxPSI = this.getDefinition().getMaxPSI(this.gauge);
            this.func_184212_Q().func_187227_b(PRESSURE_VALVE, (Object)(f > (float)maxPSI ? 1 : 0));
            if (f > (float)maxPSI) {
                waterUsed += f - (float)maxPSI;
                f = maxPSI;
            }
        } else {
            if (f > 0.0f) {
                f = Math.max(0.0f, f - (100.0f - boilerTemperature));
                boilerTemperature = 100.0f;
            }
            this.func_184212_Q().func_187227_b(PRESSURE_VALVE, (Object)false);
        }
        float throttle = Math.abs(this.getThrottle());
        if (throttle != 0.0f && f > 0.0f) {
            double burnableSlots = this.cargoItems.getSlots() - 2;
            double maxKCalTick = burnableSlots * this.coalEnergyKCalTick();
            double maxPressureTick = maxKCalTick / (double)(this.getTankCapacity().MilliBuckets() / 1000);
            float delta = (float)((double)throttle * (maxPressureTick *= 0.8));
            f = Math.max(0.0f, f - delta);
            waterUsed += delta * Config.ConfigBalance.locoWaterUsage;
        }
        if (waterUsed != 0.0f) {
            if (waterUsed > 0.0f) {
                this.theTank.drain((int)Math.floor(waterUsed), true);
                waterUsed %= 1.0f;
            }
            if (Math.random() <= (double)waterUsed) {
                this.theTank.drain(1, true);
            }
        }
        this.setBoilerPressure(f);
        this.setBoilerTemperature(Math.max(boilerTemperature, this.ambientTemperature()));
        if (changedBurnTime.booleanValue()) {
            this.setBurnTime(burnTime);
        }
        if (changedBurnMax.booleanValue()) {
            this.setBurnMax(burnMax);
        }
        if ((double)f > (double)this.getDefinition().getMaxPSI(this.gauge) * 1.1 || (double)f > (double)this.getDefinition().getMaxPSI(this.gauge) * 0.5 && boilerTemperature > 150.0f) {
            if (Config.ConfigDamage.explosionsEnabled) {
                int i;
                if (Config.ConfigDamage.explosionEnvDamageEnabled) {
                    for (i = 0; i < 5; ++i) {
                        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, f / 8.0f, true);
                    }
                } else {
                    for (i = 0; i < 5; ++i) {
                        Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, f / 5.0f, false, false);
                        explosion.func_77278_a();
                        explosion.func_77279_a(true);
                    }
                }
            }
            this.field_70170_p.func_72900_e((Entity)this);
        }
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        for (ISound chime : this.chimes) {
            chime.stop();
        }
        if (this.idle != null) {
            this.idle.stop();
        }
        if (this.pressure != null) {
            this.pressure.stop();
        }
    }

    @Override
    protected void initContainerFilter() {
        this.cargoItems.filter.clear();
        this.cargoItems.filter.put(this.getInventorySize() - 2, SlotFilter.FLUID_CONTAINER);
        this.cargoItems.filter.put(this.getInventorySize() - 1, SlotFilter.FLUID_CONTAINER);
        this.cargoItems.defaultFilter = SlotFilter.BURNABLE;
    }

    @Override
    public int getInventorySize() {
        return this.getDefinition().getInventorySize(this.gauge) + 2;
    }

    public int getInventoryWidth() {
        return this.getDefinition().getInventoryWidth(this.gauge);
    }

    @Override
    protected int[] getContainerInputSlots() {
        return new int[]{this.getInventorySize() - 2};
    }

    @Override
    protected int[] getContainertOutputSlots() {
        return new int[]{this.getInventorySize() - 1};
    }

    @Override
    public FluidQuantity getTankCapacity() {
        return this.getDefinition().getTankCapacity(this.gauge);
    }

    @Override
    public List<Fluid> getFluidFilter() {
        return LiquidUtil.getWater();
    }

    private double coalEnergyKCalTick() {
        double coalEnergyDensity = 30000.0;
        double coalEnergyKJ = coalEnergyDensity / 9.0;
        double coalEnergyBTU = coalEnergyKJ * 0.958;
        double coalEnergyKCal = coalEnergyBTU / 3968.0;
        double coalBurnTicks = 1600.0;
        double coalEnergyKCalTick = coalEnergyKCal / coalBurnTicks * (double)Config.ConfigBalance.locoHeatTimeScale;
        return coalEnergyKCalTick;
    }
}

