/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.EntitySmokeParticle;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.registry.LocomotiveDieselDefinition;
import cam72cam.immersiverailroading.sound.ISound;
import cam72cam.immersiverailroading.util.BurnUtil;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.immersiverailroading.util.VecUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class LocomotiveDiesel
extends Locomotive {
    private ISound horn;
    private ISound idle;
    private float soundThrottle;
    private float internalBurn = 0.0f;
    private int turnOnOffDelay = 0;
    private static DataParameter<Float> ENGINE_TEMPERATURE = EntityDataManager.func_187226_a(LocomotiveDiesel.class, (DataSerializer)DataSerializers.field_187193_c);
    private static DataParameter<Boolean> TURNED_ON = EntityDataManager.func_187226_a(LocomotiveDiesel.class, (DataSerializer)DataSerializers.field_187198_h);
    private static DataParameter<Boolean> ENGINE_OVERHEATED = EntityDataManager.func_187226_a(LocomotiveDiesel.class, (DataSerializer)DataSerializers.field_187198_h);

    public LocomotiveDiesel(World world) {
        this(world, null);
    }

    public LocomotiveDiesel(World world, String defID) {
        super(world, defID);
        this.func_184212_Q().func_187214_a(ENGINE_TEMPERATURE, (Object)Float.valueOf(this.ambientTemperature()));
        this.func_184212_Q().func_187214_a(TURNED_ON, (Object)false);
        this.func_184212_Q().func_187214_a(ENGINE_OVERHEATED, (Object)false);
    }

    public float getEngineTemperature() {
        return ((Float)this.field_70180_af.func_187225_a(ENGINE_TEMPERATURE)).floatValue();
    }

    private void setEngineTemperature(float temp) {
        this.field_70180_af.func_187227_b(ENGINE_TEMPERATURE, (Object)Float.valueOf(temp));
    }

    public void setTurnedOn(boolean value) {
        this.field_70180_af.func_187227_b(TURNED_ON, (Object)value);
    }

    public boolean isTurnedOn() {
        return (Boolean)this.field_70180_af.func_187225_a(TURNED_ON);
    }

    public void setEngineOverheated(boolean value) {
        this.field_70180_af.func_187227_b(ENGINE_OVERHEATED, (Object)value);
    }

    public boolean isEngineOverheated() {
        return (Boolean)this.field_70180_af.func_187225_a(ENGINE_OVERHEATED) != false && Config.ConfigBalance.canDieselEnginesOverheat;
    }

    public boolean isRunning() {
        if (!Config.isFuelRequired(this.gauge)) {
            return this.isTurnedOn();
        }
        return this.isTurnedOn() && !this.isEngineOverheated() && this.getLiquidAmount() > 0;
    }

    @Override
    public LocomotiveDieselDefinition getDefinition() {
        return super.getDefinition(LocomotiveDieselDefinition.class);
    }

    @Override
    public GuiTypes guiType() {
        return GuiTypes.DIESEL_LOCOMOTIVE;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74776_a("engine_temperature", this.getEngineTemperature());
        nbttagcompound.func_74757_a("turned_on", this.isTurnedOn());
        nbttagcompound.func_74757_a("engine_overheated", this.isEngineOverheated());
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.setEngineTemperature(nbttagcompound.func_74760_g("engine_temperature"));
        this.setTurnedOn(nbttagcompound.func_74767_n("turned_on"));
        this.setEngineOverheated(nbttagcompound.func_74767_n("engine_overheated"));
        super.func_70037_a(nbttagcompound);
    }

    @Override
    public void handleKeyPress(Entity source, KeyTypes key, boolean sprinting) {
        switch (key) {
            case START_STOP_ENGINE: {
                if (this.turnOnOffDelay != 0) break;
                this.turnOnOffDelay = 10;
                this.setTurnedOn(!this.isTurnedOn());
                break;
            }
            default: {
                super.handleKeyPress(source, key, sprinting);
            }
        }
    }

    private void setThrottleMap(EntityRollingStock stock, boolean direction) {
        if (stock instanceof LocomotiveDiesel && ((LocomotiveDiesel)stock).getDefinition().muliUnitCapable) {
            ((LocomotiveDiesel)stock).realSetThrottle(this.getThrottle() * (float)(direction ? 1 : -1));
            ((LocomotiveDiesel)stock).realAirBrake(this.getAirBrake());
        }
    }

    private void realSetThrottle(float newThrottle) {
        if (Config.isFuelRequired(this.gauge)) {
            newThrottle = Math.copySign(Math.min(Math.abs(newThrottle), this.getEngineTemperature() / 100.0f), newThrottle);
        }
        super.setThrottle(newThrottle);
    }

    private void realAirBrake(float newAirBrake) {
        super.setAirBrake(newAirBrake);
    }

    @Override
    public void setThrottle(float newThrottle) {
        this.realSetThrottle(newThrottle);
        if (this.getDefinition().muliUnitCapable) {
            this.mapTrain(this, true, false, this::setThrottleMap);
        }
    }

    @Override
    public void setAirBrake(float newAirBrake) {
        this.realAirBrake(newAirBrake);
        this.mapTrain(this, true, false, this::setThrottleMap);
    }

    @Override
    protected int getAvailableHP() {
        if (this.isRunning() && (this.getEngineTemperature() > 75.0f || !Config.isFuelRequired(this.gauge))) {
            return this.getDefinition().getHorsePower(this.gauge);
        }
        return 0;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (ConfigSound.soundEnabled) {
                float absThrottle;
                if (this.horn == null) {
                    this.horn = ImmersiveRailroading.proxy.newSound(this.getDefinition().horn, false, 100.0f, this.soundGauge());
                    this.idle = ImmersiveRailroading.proxy.newSound(this.getDefinition().idle, true, 80.0f, this.soundGauge());
                }
                if (this.isRunning()) {
                    if (!this.idle.isPlaying()) {
                        this.idle.play(this.func_174791_d());
                    }
                } else if (this.idle.isPlaying()) {
                    this.idle.stop();
                }
                if ((Integer)this.func_184212_Q().func_187225_a(HORN) != 0 && !this.horn.isPlaying() && this.isRunning()) {
                    this.horn.play(this.func_174791_d());
                }
                if (this.soundThrottle > (absThrottle = Math.abs(this.getThrottle()))) {
                    this.soundThrottle -= Math.min(0.01f, this.soundThrottle - absThrottle);
                } else if (this.soundThrottle < absThrottle) {
                    this.soundThrottle += Math.min(0.01f, absThrottle - this.soundThrottle);
                }
                if (this.horn.isPlaying()) {
                    this.horn.setPosition(this.func_174791_d());
                    this.horn.setVelocity(this.getVelocity());
                    this.horn.update();
                }
                if (this.idle.isPlaying()) {
                    this.idle.setPitch(0.7f + this.soundThrottle / 4.0f);
                    this.idle.setVolume(Math.max(0.1f, this.soundThrottle));
                    this.idle.setPosition(this.func_174791_d());
                    this.idle.setVelocity(this.getVelocity());
                    this.idle.update();
                }
            }
            if (!ConfigGraphics.particlesEnabled) {
                return;
            }
            Vec3d fakeMotion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            List<RenderComponent> exhausts = this.getDefinition().getComponents(RenderComponentType.DIESEL_EXHAUST_X, this.gauge);
            float throttle = Math.abs(this.getThrottle()) + 0.05f;
            if (exhausts != null && this.isRunning()) {
                for (RenderComponent exhaust : exhausts) {
                    Vec3d particlePos = this.func_174791_d().func_178787_e(VecUtil.rotateWrongYaw(exhaust.center(), this.field_70177_z + 180.0f));
                    double smokeMod = (1.0 + Math.min(1.0, Math.max(0.2, Math.abs(this.getCurrentSpeed().minecraft()) * 2.0))) / 2.0;
                    EntitySmokeParticle sp = new EntitySmokeParticle(this.field_70170_p, (int)((double)(40.0f * (1.0f + throttle)) * smokeMod), throttle, throttle, exhaust.width());
                    particlePos = particlePos.func_178788_d(fakeMotion);
                    sp.func_70107_b(particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                    sp.func_70016_h(fakeMotion.field_72450_a, fakeMotion.field_72448_b + 0.4 * this.gauge.scale(), fakeMotion.field_72449_c);
                    this.field_70170_p.func_72838_d((Entity)sp);
                }
            }
            return;
        }
        float engineTemperature = this.getEngineTemperature();
        float heatUpSpeed = 0.0029167f * (float)Config.ConfigBalance.dieselLocoHeatTimeScale / 1.7f;
        float ambientDelta = engineTemperature - this.ambientTemperature();
        float coolDownSpeed = heatUpSpeed * Math.copySign((float)Math.pow(ambientDelta / 130.0f, 2.0), ambientDelta);
        engineTemperature -= coolDownSpeed;
        if (this.getLiquidAmount() > 0 && this.isRunning()) {
            float consumption = Math.abs(this.getThrottle()) + 0.05f;
            float burnTime = BurnUtil.getBurnTime(this.getLiquid());
            if (burnTime == 0.0f) {
                burnTime = 200.0f;
            }
            burnTime *= (float)this.getDefinition().getFuelEfficiency() / 100.0f;
            burnTime *= (float)Config.ConfigBalance.locoDieselFuelEfficiency / 100.0f;
            while (this.internalBurn < 0.0f && this.getLiquidAmount() > 0) {
                this.internalBurn += burnTime;
                this.theTank.drain(1, true);
            }
            consumption *= 100.0f;
            consumption = (float)((double)consumption * this.gauge.scale());
            this.internalBurn -= consumption;
            if ((engineTemperature += heatUpSpeed * (Math.abs(this.getThrottle()) + 0.2f)) > 150.0f) {
                engineTemperature = 150.0f;
                this.setEngineOverheated(true);
            }
        }
        if (engineTemperature < 100.0f && this.isEngineOverheated()) {
            this.setEngineOverheated(false);
        }
        if (this.turnOnOffDelay > 0) {
            --this.turnOnOffDelay;
        }
        this.setEngineTemperature(engineTemperature);
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        if (this.idle != null) {
            this.idle.stop();
        }
        if (this.horn != null) {
            this.horn.stop();
        }
    }

    @Override
    public List<Fluid> getFluidFilter() {
        return BurnUtil.burnableFluids();
    }

    @Override
    public FluidQuantity getTankCapacity() {
        return this.getDefinition().getFuelCapacity(this.gauge);
    }

    @Override
    public void onDissassemble() {
        super.onDissassemble();
        this.setEngineTemperature(this.ambientTemperature());
        this.setEngineOverheated(false);
        this.setTurnedOn(false);
    }
}

