/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.util.Speed;
import com.google.common.base.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public abstract class Locomotive
extends FreightTank {
    private static DataParameter<Float> THROTTLE = EntityDataManager.func_187226_a(Locomotive.class, (DataSerializer)DataSerializers.field_187193_c);
    private static DataParameter<Float> AIR_BRAKE = EntityDataManager.func_187226_a(Locomotive.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static DataParameter<Integer> HORN = EntityDataManager.func_187226_a(Locomotive.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static DataParameter<Optional<UUID>> HORN_PLAYER = EntityDataManager.func_187226_a(Locomotive.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final float throttleNotch = 0.04f;
    private static final float airBrakeNotch = 0.04f;
    private boolean deadMansSwitch;
    private int deadManChangeTimeout;

    public Locomotive(World world, String defID) {
        super(world, defID);
        this.func_184212_Q().func_187214_a(THROTTLE, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(AIR_BRAKE, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(HORN, (Object)0);
        this.func_184212_Q().func_187214_a(HORN_PLAYER, (Object)Optional.absent());
        this.field_70144_Y = 0.99f;
    }

    @Override
    public LocomotiveDefinition getDefinition() {
        return super.getDefinition(LocomotiveDefinition.class);
    }

    @Override
    public GuiTypes guiType() {
        return null;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74776_a("throttle", this.getThrottle());
        nbttagcompound.func_74776_a("brake", this.getAirBrake());
        nbttagcompound.func_74757_a("deadMansSwitch", this.deadMansSwitch);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setThrottle(nbttagcompound.func_74760_g("throttle"));
        this.setAirBrake(nbttagcompound.func_74760_g("brake"));
        this.deadMansSwitch = nbttagcompound.func_74767_n("deadMansSwitch");
    }

    @Override
    public void handleKeyPress(Entity source, KeyTypes key, boolean sprinting) {
        switch (key) {
            case HORN: {
                this.setHorn(10, source.getPersistentID());
                break;
            }
            case THROTTLE_UP: {
                if (!(this.getThrottle() < 1.0f)) break;
                this.setThrottle(this.getThrottle() + 0.04f);
                break;
            }
            case THROTTLE_ZERO: {
                this.setThrottle(0.0f);
                break;
            }
            case THROTTLE_DOWN: {
                if (!(this.getThrottle() > -1.0f)) break;
                this.setThrottle(this.getThrottle() - 0.04f);
                break;
            }
            case AIR_BRAKE_UP: {
                if (!(this.getAirBrake() < 1.0f)) break;
                this.setAirBrake(this.getAirBrake() + 0.04f);
                break;
            }
            case AIR_BRAKE_ZERO: {
                this.setAirBrake(0.0f);
                break;
            }
            case AIR_BRAKE_DOWN: {
                if (!(this.getAirBrake() > 0.0f)) break;
                this.setAirBrake(this.getAirBrake() - 0.04f);
                break;
            }
            case DEAD_MANS_SWITCH: {
                if (this.deadManChangeTimeout != 0) break;
                boolean bl = this.deadMansSwitch = !this.deadMansSwitch;
                if (this.deadMansSwitch) {
                    source.func_145747_a((ITextComponent)ChatText.DEADMANS_SWITCH_ENABLED.getMessage(new Object[0]));
                } else {
                    source.func_145747_a((ITextComponent)ChatText.DEADMANS_SWITCH_DISABLED.getMessage(new Object[0]));
                }
                this.deadManChangeTimeout = 5;
                break;
            }
            default: {
                super.handleKeyPress(source, key, sprinting);
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.deadManChangeTimeout > 0) {
                --this.deadManChangeTimeout;
            }
            if (this.deadMansSwitch && !this.getCurrentSpeed().isZero()) {
                boolean hasDriver = false;
                for (Entity entity : this.func_184188_bt()) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    hasDriver = true;
                    break;
                }
                if (!hasDriver) {
                    this.setThrottle(0.0f);
                    this.setAirBrake(1.0f);
                }
            }
            if ((Integer)this.func_184212_Q().func_187225_a(HORN) > 0) {
                this.func_184212_Q().func_187227_b(HORN, (Object)((Integer)this.func_184212_Q().func_187225_a(HORN) - 1));
            } else if (((Optional)this.func_184212_Q().func_187225_a(HORN_PLAYER)).isPresent()) {
                this.func_184212_Q().func_187227_b(HORN_PLAYER, (Object)Optional.absent());
            }
        }
        this.simulateWheelSlip();
    }

    protected abstract int getAvailableHP();

    private double getAppliedTractiveEffort(Speed speed) {
        double locoEfficiency = 0.7f;
        double outputHorsepower = Math.abs(Math.pow(this.getThrottle(), 3.0) * (double)this.getAvailableHP());
        double tractiveEffortNewtons = 2650.0 * (locoEfficiency * outputHorsepower / Math.max(1.4, Math.abs(speed.metric())));
        return tractiveEffortNewtons;
    }

    private void simulateWheelSlip() {
        double tractiveEffortNewtons = this.getAppliedTractiveEffort(this.getCurrentSpeed());
        double staticTractiveEffort = (double)this.getDefinition().getStartingTractionNewtons(this.gauge) * this.slipCoefficient() * Config.ConfigBalance.tractionMultiplier;
        double adhesionFactor = tractiveEffortNewtons / (staticTractiveEffort *= 1.5);
        if (adhesionFactor > 1.0) {
            this.distanceTraveled = (float)((double)this.distanceTraveled + Math.copySign(Math.min((adhesionFactor - 1.0) / 10.0, 1.0), (double)this.getThrottle()));
        }
    }

    public double getTractiveEffortNewtons(Speed speed) {
        if (!this.isBuilt()) {
            return 0.0;
        }
        double tractiveEffortNewtons = this.getAppliedTractiveEffort(speed);
        double staticTractiveEffort = (double)this.getDefinition().getStartingTractionNewtons(this.gauge) * this.slipCoefficient() * Config.ConfigBalance.tractionMultiplier;
        double adhesionFactor = tractiveEffortNewtons / (staticTractiveEffort *= 1.5);
        if (adhesionFactor > 1.0) {
            double us = 0.74;
            double uk = 0.57;
            tractiveEffortNewtons = staticTractiveEffort * (uk / us) / adhesionFactor;
        }
        if (Math.abs(speed.minecraft()) > this.getDefinition().getMaxSpeed(this.gauge).minecraft()) {
            tractiveEffortNewtons = 0.0;
        }
        return Math.copySign(tractiveEffortNewtons, (double)this.getThrottle());
    }

    public float getThrottle() {
        return ((Float)this.field_70180_af.func_187225_a(THROTTLE)).floatValue();
    }

    public void setThrottle(float newThrottle) {
        if (this.getThrottle() != newThrottle) {
            this.field_70180_af.func_187227_b(THROTTLE, (Object)Float.valueOf(newThrottle));
            this.triggerResimulate();
        }
    }

    public void setHorn(int val, UUID uuid) {
        UUID currentPlayer;
        UUID uUID = currentPlayer = ((Optional)this.func_184212_Q().func_187225_a(HORN_PLAYER)).isPresent() ? (UUID)((Optional)this.func_184212_Q().func_187225_a(HORN_PLAYER)).get() : null;
        if (currentPlayer == null && uuid != null) {
            currentPlayer = uuid;
            this.func_184212_Q().func_187227_b(HORN_PLAYER, (Object)Optional.of((Object)uuid));
        }
        if (currentPlayer == null || currentPlayer == uuid) {
            this.func_184212_Q().func_187227_b(HORN, (Object)val);
        }
    }

    public float getAirBrake() {
        return ((Float)this.field_70180_af.func_187225_a(AIR_BRAKE)).floatValue();
    }

    public void setAirBrake(float newAirBrake) {
        if (this.getAirBrake() != newAirBrake) {
            this.field_70180_af.func_187227_b(AIR_BRAKE, (Object)Float.valueOf(newAirBrake));
            this.triggerResimulate();
        }
    }

    public double slipCoefficient() {
        double slipMult = 1.0;
        World world = this.func_130014_f_();
        if (world.func_72896_J() && world.func_175678_i(this.func_180425_c())) {
            Biome biome = world.func_180494_b(this.func_180425_c());
            if (biome.func_76738_d()) {
                slipMult = 0.6;
            }
            if (biome.func_150559_j()) {
                slipMult = 0.4;
            }
        }
        if (this.getCurrentSpeed().metric() != 0.0) {
            double balance = 1.0 - 0.004 * Math.abs(this.getCurrentSpeed().metric());
            slipMult *= balance;
        }
        return slipMult;
    }

    public float ambientTemperature() {
        float mctemp = this.field_70170_p.func_180494_b(this.func_180425_c()).func_180626_a(this.func_180425_c());
        return 13.64848f * mctemp + 7.087969f;
    }
}

