/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.inventory.FilteredStackHandler;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.StockDeathType;
import cam72cam.immersiverailroading.registry.FreightDefinition;
import cam72cam.immersiverailroading.util.VecUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class Freight
extends EntityCoupleableRollingStock {
    protected FilteredStackHandler cargoItems = new FilteredStackHandler(0){

        protected void onContentsChanged(int slot) {
            Freight.this.onInventoryChanged();
        }
    };
    protected static DataParameter<Integer> CARGO_ITEMS = EntityDataManager.func_187226_a(Freight.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static DataParameter<Integer> PERCENT_FULL = EntityDataManager.func_187226_a(Freight.class, (DataSerializer)DataSerializers.field_187192_b);

    public Freight(World world, String defID) {
        super(world, defID);
        this.func_184212_Q().func_187214_a(CARGO_ITEMS, (Object)0);
        this.func_184212_Q().func_187214_a(PERCENT_FULL, (Object)0);
    }

    protected void onInventoryChanged() {
        if (!this.field_70170_p.field_72995_K) {
            this.handleMass();
        }
    }

    public abstract int getInventorySize();

    public boolean showCurrentLoadOnly() {
        return this.getDefinition().shouldShowCurrentLoadOnly();
    }

    @Override
    public FreightDefinition getDefinition() {
        return this.getDefinition(FreightDefinition.class);
    }

    @Override
    public void onAssemble() {
        super.onAssemble();
        this.cargoItems.setSize(this.getInventorySize());
    }

    @Override
    public void onDissassemble() {
        super.onDissassemble();
        if (!this.field_70170_p.field_72995_K) {
            for (int slot = 0; slot < this.cargoItems.getSlots(); ++slot) {
                ItemStack itemstack = this.cargoItems.getStackInSlot(slot);
                if (itemstack.func_190916_E() == 0) continue;
                Vec3d pos = this.func_174791_d().func_178787_e(VecUtil.fromWrongYaw(4.0, this.field_70177_z + 90.0f));
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, itemstack.func_77946_l()));
                itemstack.func_190920_e(0);
            }
        }
        this.cargoItems.setSize(0);
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        EntityLiving passenger;
        if (super.func_184230_a(player, hand)) {
            return true;
        }
        if (!this.isBuilt()) {
            return false;
        }
        double dist = 10.0;
        double i = player.field_70165_t;
        double j = player.field_70163_u;
        double k = player.field_70161_v;
        for (EntityLiving entityliving : this.field_70170_p.func_72872_a(EntityLiving.class, new AxisAlignedBB(i - dist, j - 7.0, k - dist, i + dist, j + dist, k + dist))) {
            if (!entityliving.func_110167_bD() || entityliving.func_110166_bE() != player || !this.func_184219_q((Entity)entityliving) || !this.getDefinition().acceptsLivestock()) continue;
            entityliving.func_110160_i(true, !player.func_184812_l_());
            this.addStaticPassenger(entityliving, player.func_174791_d());
            return true;
        }
        if (player.func_184614_ca().func_77973_b() == Items.field_151058_ca && (passenger = this.removeStaticPasssenger(player.func_174791_d(), false)) != null) {
            if (passenger.func_184652_a(player)) {
                passenger.func_110162_b((Entity)player, true);
                player.func_184614_ca().func_190918_g(1);
                return true;
            }
            return true;
        }
        if (this.guiType() != null) {
            player.openGui((Object)ImmersiveRailroading.instance, this.guiType().ordinal(), this.field_70170_p, this.func_145782_y(), 0, 0);
            return true;
        }
        return false;
    }

    protected GuiTypes guiType() {
        return GuiTypes.FREIGHT;
    }

    protected void handleMass() {
        int itemInsideCount = 0;
        int stacksWithStuff = 0;
        for (int slot = 0; slot < this.cargoItems.getSlots(); ++slot) {
            itemInsideCount += this.cargoItems.getStackInSlot(slot).func_190916_E();
            if (this.cargoItems.getStackInSlot(slot).func_190916_E() == 0) continue;
            ++stacksWithStuff;
        }
        this.func_184212_Q().func_187227_b(CARGO_ITEMS, (Object)itemInsideCount);
        this.func_184212_Q().func_187227_b(PERCENT_FULL, (Object)(stacksWithStuff * 100 / this.getInventorySize()));
    }

    public int getPercentCargoFull() {
        return (Integer)this.func_184212_Q().func_187225_a(PERCENT_FULL);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74782_a("items", (NBTBase)this.cargoItems.serializeNBT());
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        ItemStackHandler temp = new ItemStackHandler();
        temp.deserializeNBT((NBTTagCompound)nbttagcompound.func_74781_a("items"));
        this.cargoItems.setSize(this.getInventorySize());
        for (int slot = 0; slot < temp.getSlots(); ++slot) {
            if (slot < this.cargoItems.getSlots()) {
                this.cargoItems.setStackInSlot(slot, temp.getStackInSlot(slot));
                continue;
            }
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, temp.getStackInSlot(slot)));
        }
        this.handleMass();
        this.initContainerFilter();
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.initContainerFilter();
    }

    protected void initContainerFilter() {
    }

    @Override
    public void onDeath(StockDeathType type) {
        super.onDeath(type);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        for (int slot = 0; slot < this.cargoItems.getSlots(); ++slot) {
            ItemStack itemstack = this.cargoItems.getStackInSlot(slot);
            if (itemstack.func_190916_E() == 0) continue;
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemstack.func_77946_l()));
            itemstack.func_190920_e(0);
        }
    }

    @Override
    public double getWeight() {
        double fLoad = Config.ConfigBalance.blockWeight * (Integer)this.func_184212_Q().func_187225_a(CARGO_ITEMS);
        return fLoad += super.getWeight();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.cargoItems);
        }
        return (T)super.getCapability(capability, facing);
    }
}

