/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.StockDeathType;
import cam72cam.immersiverailroading.net.PaintSyncPacket;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.util.BufferUtil;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityRollingStock
extends Entity
implements IEntityAdditionalSpawnData {
    protected String defID;
    public Gauge gauge;
    public String tag = "";
    public String texture;

    public EntityRollingStock(World world, String defID) {
        super(world);
        this.defID = defID;
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.field_70144_Y = 1.0f;
        this.field_70158_ak = true;
    }

    public String func_70005_c_() {
        return this.getDefinition().name();
    }

    public EntityRollingStockDefinition getDefinition() {
        return this.getDefinition(EntityRollingStockDefinition.class);
    }

    public <T extends EntityRollingStockDefinition> T getDefinition(Class<T> type) {
        EntityRollingStockDefinition def = DefinitionManager.getDefinition(this.defID);
        if (def == null) {
            try {
                return (T)((EntityRollingStockDefinition)type.getConstructor(String.class, JsonObject.class).newInstance(this.defID, null));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        return (T)((EntityRollingStockDefinition)type.cast(def));
    }

    public String getDefinitionID() {
        return this.defID;
    }

    public void func_70071_h_() {
        EntityRollingStockDefinition def;
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0 && (def = DefinitionManager.getDefinition(this.defID)) == null) {
            this.field_70170_p.func_72900_e((Entity)this);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.defID = BufferUtil.readString(additionalData);
        this.gauge = Gauge.from(additionalData.readDouble());
        this.tag = BufferUtil.readString(additionalData);
        if (additionalData.readBoolean()) {
            this.texture = BufferUtil.readString(additionalData);
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        BufferUtil.writeString(buffer, this.defID);
        buffer.writeDouble(this.gauge.value());
        BufferUtil.writeString(buffer, this.tag);
        buffer.writeBoolean(this.texture != null);
        if (this.texture != null) {
            BufferUtil.writeString(buffer, this.texture);
        }
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("defID", this.defID);
        nbttagcompound.func_74780_a("gauge", this.gauge.value());
        nbttagcompound.func_74778_a("tag", this.tag);
        if (this.texture != null) {
            nbttagcompound.func_74778_a("texture", this.texture);
        }
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.defID = nbttagcompound.func_74779_i("defID");
        this.gauge = nbttagcompound.func_74764_b("gauge") ? Gauge.from(nbttagcompound.func_74769_h("gauge")) : Gauge.from(1.435);
        this.tag = nbttagcompound.func_74779_i("tag");
        if (nbttagcompound.func_74764_b("texture")) {
            this.texture = nbttagcompound.func_74779_i("texture");
        }
    }

    protected void func_70088_a() {
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ArrayList<String> texNames;
        if (player.func_184586_b(hand).func_77973_b() == IRItems.ITEM_PAINT_BRUSH && (texNames = new ArrayList<String>(this.getDefinition().textureNames.keySet())).size() > 1) {
            int idx = texNames.indexOf(this.texture);
            idx = (idx + (player.func_70093_af() ? -1 : 1) + texNames.size()) % texNames.size();
            this.texture = (String)texNames.get(idx);
            this.sendToObserving(new PaintSyncPacket(this));
            return true;
        }
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void onDeath(StockDeathType type) {
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource damagesource, float amount) {
        EntityPlayer player;
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (damagesource.func_94541_c() && amount > 5.0f && (Config.ConfigDamage.trainMobExplosionDamage || !(damagesource.func_76346_g() instanceof EntityMob))) {
            if (!this.field_70128_L) {
                this.onDeath(amount > 20.0f ? StockDeathType.CATACYSM : StockDeathType.EXPLOSION);
            }
            this.field_70170_p.func_72900_e((Entity)this);
            return false;
        }
        if (damagesource.func_76346_g() instanceof EntityPlayer && !damagesource.func_76352_a() && (player = (EntityPlayer)damagesource.func_76346_g()).func_70093_af()) {
            if (!this.field_70128_L) {
                this.onDeath(StockDeathType.PLAYER);
            }
            this.field_70170_p.func_72900_e((Entity)this);
            return false;
        }
        return false;
    }

    public <T extends Entity> Collection<T> func_184180_b(Class<T> entityClass) {
        try {
            throw new Exception("Hack the planet");
        }
        catch (Exception ex) {
            for (StackTraceElement tl : ex.getStackTrace()) {
                if (!tl.getFileName().contains("PlayerList.java")) continue;
                return new ArrayList();
            }
            return super.func_184180_b(entityClass);
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public double getWeight() {
        return this.getDefinition().getWeight(this.gauge);
    }

    public void sendToObserving(IMessage packet) {
        boolean found = false;
        for (EntityPlayer player : this.field_70170_p.field_73010_i) {
            if (!(player.func_174791_d().func_72438_d(this.func_174791_d()) < 512.0)) continue;
            found = true;
            break;
        }
        if (found) {
            ImmersiveRailroading.net.sendToAllAround(packet, new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 512.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }

    public void triggerResimulate() {
    }

    public void renderTick(float partialTicks) {
    }

    public Gauge soundGauge() {
        return this.getDefinition().shouldScalePitch() ? this.gauge : Gauge.from(1.435);
    }
}

