/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.net.MRSSyncPacket;
import cam72cam.immersiverailroading.net.SoundPacket;
import cam72cam.immersiverailroading.physics.PhysicsAccummulator;
import cam72cam.immersiverailroading.physics.TickPos;
import cam72cam.immersiverailroading.proxy.ChunkManager;
import cam72cam.immersiverailroading.util.BufferUtil;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.immersiverailroading.util.VecUtil;
import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public abstract class EntityCoupleableRollingStock
extends EntityMoveableRollingStock {
    private boolean resimulate = false;
    public boolean isAttaching = false;
    private UUID coupledFront = null;
    private BlockPos lastKnownFront = null;
    private boolean frontCouplerEngaged = true;
    private Vec3d couplerFrontPosition = null;
    private UUID coupledBack = null;
    private BlockPos lastKnownRear = null;
    private boolean backCouplerEngaged = true;
    private Vec3d couplerRearPosition = null;

    public EntityCoupleableRollingStock(World world, String defID) {
        super(world, defID);
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.coupledFront = BufferUtil.readUUID(additionalData);
        this.coupledBack = BufferUtil.readUUID(additionalData);
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        BufferUtil.writeUUID(buffer, this.coupledFront);
        BufferUtil.writeUUID(buffer, this.coupledBack);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        if (this.coupledFront != null) {
            nbttagcompound.func_74778_a("CoupledFront", this.coupledFront.toString());
            if (this.lastKnownFront != null) {
                nbttagcompound.func_74772_a("lastKnownFront", this.lastKnownFront.func_177986_g());
            }
        }
        nbttagcompound.func_74757_a("frontCouplerEngaged", this.frontCouplerEngaged);
        if (this.coupledBack != null) {
            nbttagcompound.func_74778_a("CoupledBack", this.coupledBack.toString());
            if (this.lastKnownRear != null) {
                nbttagcompound.func_74772_a("lastKnownRear", this.lastKnownRear.func_177986_g());
            }
        }
        nbttagcompound.func_74757_a("backCouplerEngaged", this.backCouplerEngaged);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        NBTTagCompound pos;
        super.func_70037_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("CoupledFront")) {
            this.coupledFront = UUID.fromString(nbttagcompound.func_74779_i("CoupledFront"));
            if (nbttagcompound.func_74764_b("lastKnownFront")) {
                if (nbttagcompound.func_74781_a("lastKnownFront").func_74732_a() == 10) {
                    pos = nbttagcompound.func_74775_l("lastKnownFront");
                    this.lastKnownFront = new BlockPos(pos.func_74762_e("x"), pos.func_74762_e("y"), pos.func_74762_e("z"));
                } else {
                    this.lastKnownFront = BlockPos.func_177969_a((long)nbttagcompound.func_74763_f("lastKnownFront"));
                }
            }
        }
        this.frontCouplerEngaged = nbttagcompound.func_74767_n("frontCouplerEngaged");
        if (nbttagcompound.func_74764_b("CoupledBack")) {
            this.coupledBack = UUID.fromString(nbttagcompound.func_74779_i("CoupledBack"));
            if (nbttagcompound.func_74781_a("lastKnownRear").func_74732_a() == 10) {
                pos = nbttagcompound.func_74775_l("lastKnownRear");
                this.lastKnownRear = new BlockPos(pos.func_74762_e("x"), pos.func_74762_e("y"), pos.func_74762_e("z"));
            } else {
                this.lastKnownRear = BlockPos.func_177969_a((long)nbttagcompound.func_74763_f("lastKnownRear"));
            }
        }
        this.backCouplerEngaged = nbttagcompound.func_74767_n("backCouplerEngaged");
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_184586_b(hand).func_77973_b() == IRItems.ITEM_HOOK) {
            CouplerType coupler = CouplerType.FRONT;
            if (this.getCouplerPosition(CouplerType.FRONT).func_72438_d(player.func_174791_d()) > this.getCouplerPosition(CouplerType.BACK).func_72438_d(player.func_174791_d())) {
                coupler = CouplerType.BACK;
            }
            if (player.func_70093_af()) {
                this.setCouplerEngaged(coupler, !this.isCouplerEngaged(coupler));
                if (this.isCouplerEngaged(coupler)) {
                    player.func_145747_a((ITextComponent)ChatText.COUPLER_ENGAGED.getMessage(new Object[]{coupler}));
                } else {
                    player.func_145747_a((ITextComponent)ChatText.COUPLER_DISENGAGED.getMessage(new Object[]{coupler}));
                }
            } else if (this.isCoupled(coupler) && this.isCouplerEngaged(coupler)) {
                EntityCoupleableRollingStock coupled = this.getCoupled(coupler);
                player.func_145747_a((ITextComponent)ChatText.COUPLER_STATUS_COUPLED.getMessage(new Object[]{coupler, coupled.getDefinition().name(), coupled.func_180425_c().func_177958_n(), coupled.func_180425_c().func_177956_o(), coupled.func_180425_c().func_177952_p()}));
            } else if (this.isCouplerEngaged(coupler)) {
                player.func_145747_a((ITextComponent)ChatText.COUPLER_STATUS_DECOUPLED_ENGAGED.getMessage(new Object[]{coupler}));
            } else {
                player.func_145747_a((ITextComponent)ChatText.COUPLER_STATUS_DECOUPLED_DISENGAGED.getMessage(new Object[]{coupler}));
            }
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getCurrentSpeed().minecraft() != 0.0 || Config.ConfigDebug.keepStockLoaded) {
            ChunkManager.flagEntityPos(this.field_70170_p, this.func_180425_c());
            ChunkManager.flagEntityPos(this.field_70170_p, new BlockPos(this.guessCouplerPosition(CouplerType.FRONT)));
            ChunkManager.flagEntityPos(this.field_70170_p, new BlockPos(this.guessCouplerPosition(CouplerType.BACK)));
            if (this.lastKnownFront != null) {
                ChunkManager.flagEntityPos(this.field_70170_p, this.lastKnownFront);
            }
            if (this.lastKnownRear != null) {
                ChunkManager.flagEntityPos(this.field_70170_p, this.lastKnownRear);
            }
        }
        for (CouplerType coupler : CouplerType.values()) {
            CouplerType otherCoupler;
            if (!this.isCoupled(coupler)) continue;
            EntityCoupleableRollingStock coupled = this.getCoupled(coupler);
            if (coupled == null) {
                if (this.field_70173_aa <= 20) continue;
                ImmersiveRailroading.warn("Coupled entity was not loaded after 20 ticks, decoupling", new Object[0]);
                this.decouple(coupler);
                continue;
            }
            if (coupled.field_70128_L) {
                ImmersiveRailroading.warn("Removing Dead Stock", new Object[0]);
                this.decouple(coupler);
                continue;
            }
            if (coupler == CouplerType.FRONT) {
                this.lastKnownFront = coupled.func_180425_c();
            } else {
                this.lastKnownRear = coupled.func_180425_c();
            }
            if (this.isCouplerEngaged(coupler) || (otherCoupler = coupled.getCouplerFor(this)) == null || !(this.getCouplerPosition(coupler).func_72438_d(coupled.getCouplerPosition(otherCoupler)) > Config.ConfigDebug.couplerRange * 4.0)) continue;
            this.decouple(coupled);
        }
        for (CouplerType coupler : CouplerType.values()) {
            Pair<EntityCoupleableRollingStock, CouplerType> potential;
            if (this.isCoupled(coupler) || (potential = this.potentialCouplings(coupler)) == null) continue;
            EntityCoupleableRollingStock stock = (EntityCoupleableRollingStock)((Object)potential.getLeft());
            CouplerType otherCoupler = (CouplerType)((Object)potential.getRight());
            this.setCoupledUUID(coupler, stock.getPersistentID());
            stock.setCoupledUUID(otherCoupler, this.getPersistentID());
            if (!stock.isCouplerEngaged(otherCoupler) || !this.isCouplerEngaged(coupler)) continue;
            this.sendToObserving(new SoundPacket("immersiverailroading:sounds/default/coupling.ogg", this.getCouplerPosition(coupler), this.getVelocity(), 1.0f, 1.0f, 200, this.gauge));
        }
    }

    private Vec3d guessCouplerPosition(CouplerType coupler) {
        return this.func_174791_d().func_178787_e(VecUtil.fromWrongYaw(this.getDefinition().getLength(this.gauge) / 2.0 * (double)(coupler == CouplerType.FRONT ? 1 : -1), this.field_70177_z));
    }

    public void tickPosRemainingCheck() {
        if (this.getRemainingPositions() < 10 || this.resimulate) {
            TickPos lastPos = this.getCurrentTickPosAndPrune();
            if (lastPos == null) {
                this.triggerResimulate();
                return;
            }
            if (this.resimulate && this.field_70173_aa % 5 != 0) {
                return;
            }
            this.simulateCoupledRollingStock();
        }
    }

    private Speed getMovement(TickPos currentPos, boolean followStock) {
        PhysicsAccummulator acc = new PhysicsAccummulator(currentPos);
        this.mapTrain(this, true, followStock, acc::accumulate);
        return acc.getVelocity();
    }

    private Speed getMovement(TickPos currentPos, Collection<DirectionalStock> train) {
        PhysicsAccummulator acc = new PhysicsAccummulator(currentPos);
        for (DirectionalStock stock : train) {
            acc.accumulate(stock.stock, stock.direction);
        }
        return acc.getVelocity();
    }

    public void simulateCoupledRollingStock() {
        TickPos lastPos = this.getCurrentTickPosAndPrune();
        this.positions = new ArrayList();
        this.positions.add(lastPos);
        Collection<DirectionalStock> train = this.getDirectionalTrain(true);
        Speed simSpeed = this.getCurrentSpeed();
        boolean isStuck = false;
        for (DirectionalStock stock : train) {
            if (stock.stock.areWheelsBuilt()) continue;
            isStuck = true;
        }
        for (int tickOffset = 1; tickOffset < 30; ++tickOffset) {
            simSpeed = this.getMovement((TickPos)this.positions.get(tickOffset - 1), train);
            if (isStuck) {
                simSpeed = Speed.ZERO;
            }
            TickPos pos = this.moveRollingStock(simSpeed.minecraft(), lastPos.tickID + tickOffset - 1);
            this.positions.add(pos);
            for (DirectionalStock stock : train) {
                if (stock.stock.func_110124_au().equals(this.func_110124_au())) continue;
                isStuck &= !stock.stock.simulateMove(stock.prev, tickOffset);
            }
        }
        for (DirectionalStock entity : train) {
            entity.stock.sendToObserving(new MRSSyncPacket(entity.stock, entity.stock.positions));
            entity.stock.resimulate = false;
        }
    }

    private boolean simulateMove(EntityCoupleableRollingStock parent, int tickOffset) {
        double dist;
        double prevDist;
        boolean onTrack;
        if (this.positions.size() < tickOffset) {
            ImmersiveRailroading.debug("MISSING START POS " + tickOffset, new Object[0]);
            return true;
        }
        TickPos currentPos = (TickPos)this.positions.get(tickOffset - 1);
        if (parent.positions.size() <= tickOffset) {
            return currentPos.isOffTrack;
        }
        TickPos parentPos = (TickPos)parent.positions.get(tickOffset);
        boolean bl = onTrack = !currentPos.isOffTrack;
        if (tickOffset == 1) {
            this.positions = new ArrayList();
            this.positions.add(currentPos);
        }
        CouplerType coupler = this.getCouplerFor(parent);
        CouplerType otherCoupler = parent.getCouplerFor(this);
        if (coupler == null) {
            parent.decouple(this);
            this.decouple(parent);
            ImmersiveRailroading.warn("COUPLER NULL", new Object[0]);
            return onTrack;
        }
        if (!(this.isCouplerEngaged(coupler) && parent.isCouplerEngaged(otherCoupler) || this.field_70173_aa <= 5 || parent.field_70173_aa <= 5 || parent.positions.size() < 2 || !((prevDist = currentPos.position.func_72438_d(((TickPos)parent.positions.get((int)(tickOffset - 1))).position)) <= (dist = currentPos.position.func_72438_d(((TickPos)parent.positions.get((int)tickOffset)).position))))) {
            TickPos nextPos = this.moveRollingStock(this.getMovement(currentPos, false).minecraft(), currentPos.tickID);
            this.positions.add(nextPos);
            if (nextPos.isOffTrack) {
                onTrack = false;
            }
            return onTrack;
        }
        Vec3d myOffset = this.getCouplerPositionTo(coupler, currentPos, parentPos);
        Vec3d otherOffset = parent.getCouplerPositionTo(otherCoupler, parentPos, currentPos);
        if (otherOffset == null) {
            if (!this.field_70170_p.field_72995_K) {
                ImmersiveRailroading.warn(String.format("Broken Coupling %s => %s", this.getPersistentID(), parent.getPersistentID()), new Object[0]);
            }
            return onTrack;
        }
        double distance = myOffset.func_72438_d(otherOffset);
        Vec3d nextPosForward = myOffset.func_178787_e(VecUtil.fromWrongYaw(distance, currentPos.rotationYaw));
        Vec3d nextPosReverse = myOffset.func_178787_e(VecUtil.fromWrongYaw(-distance, currentPos.rotationYaw));
        if (otherOffset.func_72438_d(nextPosForward) > otherOffset.func_72438_d(nextPosReverse)) {
            distance = -distance;
        }
        TickPos nextPos = this.moveRollingStock(distance, currentPos.tickID);
        this.positions.add(nextPos);
        if (nextPos.isOffTrack) {
            onTrack = false;
        }
        if (nextPos.speed.metric() != 0.0) {
            ChunkManager.flagEntityPos(this.field_70170_p, new BlockPos(nextPos.position));
            for (CouplerType toChunk : CouplerType.values()) {
                ChunkManager.flagEntityPos(this.field_70170_p, new BlockPos(this.getCouplerPosition(toChunk, nextPos)));
            }
        }
        return onTrack;
    }

    public final void setCoupledUUID(CouplerType coupler, UUID id) {
        if (id != null && id.equals(this.getCoupledUUID(coupler))) {
            return;
        }
        switch (coupler) {
            case FRONT: {
                this.coupledFront = id;
                if (id != null) break;
                this.lastKnownFront = null;
                break;
            }
            case BACK: {
                this.coupledBack = id;
                if (id != null) break;
                this.lastKnownRear = null;
            }
        }
        if (this.getCoupled(coupler) != null) {
            BiConsumer<EntityCoupleableRollingStock, Boolean> fn = new BiConsumer<EntityCoupleableRollingStock, Boolean>(){
                double speed = 0.0;
                double weight = 0.0;

                @Override
                public void accept(EntityCoupleableRollingStock e, Boolean direction) {
                    this.speed += e.getCurrentSpeed().metric() * e.getWeight() * (double)(direction != false ? 1 : -1);
                    this.weight += e.getWeight();
                }

                public int hashCode() {
                    return (int)(this.speed / this.weight);
                }
            };
            this.mapTrain(this, true, true, fn);
            Speed speedPos = Speed.fromMetric(fn.hashCode());
            Speed speedNeg = Speed.fromMetric(-fn.hashCode());
            this.mapTrain(this, true, true, (e, b) -> e.setCurrentSpeed(b != false ? speedPos : speedNeg));
        }
        this.triggerTrain();
    }

    public final UUID getCoupledUUID(CouplerType coupler) {
        switch (coupler) {
            case FRONT: {
                return this.coupledFront;
            }
            case BACK: {
                return this.coupledBack;
            }
        }
        return null;
    }

    public EntityCoupleableRollingStock getCoupled(CouplerType coupler) {
        EntityCoupleableRollingStock stock = null;
        if (stock == null && this.getCoupledUUID(coupler) != null) {
            switch (coupler) {
                case FRONT: {
                    EntityCoupleableRollingStock coupledStockFront = this.findByUUID(this.getCoupledUUID(coupler));
                    return coupledStockFront;
                }
                case BACK: {
                    EntityCoupleableRollingStock coupledStockBack = this.findByUUID(this.getCoupledUUID(coupler));
                    return coupledStockBack;
                }
            }
        }
        return stock;
    }

    public CouplerType getCouplerFor(EntityCoupleableRollingStock stock) {
        if (stock == null) {
            return null;
        }
        for (CouplerType coupler : CouplerType.values()) {
            if (!stock.func_110124_au().equals(this.getCoupledUUID(coupler))) continue;
            return coupler;
        }
        return null;
    }

    public boolean isCouplerEngaged(CouplerType coupler) {
        if (coupler == null) {
            return false;
        }
        switch (coupler) {
            case FRONT: {
                return this.frontCouplerEngaged;
            }
            case BACK: {
                return this.backCouplerEngaged;
            }
        }
        return false;
    }

    public void setCouplerEngaged(CouplerType coupler, boolean engaged) {
        switch (coupler) {
            case FRONT: {
                this.frontCouplerEngaged = engaged;
                break;
            }
            case BACK: {
                this.backCouplerEngaged = engaged;
            }
        }
    }

    public final boolean isCoupled() {
        return this.isCoupled(CouplerType.FRONT) && this.isCoupled(CouplerType.BACK);
    }

    public final boolean isCoupled(CouplerType coupler) {
        return this.getCoupledUUID(coupler) != null;
    }

    public final boolean isCoupled(EntityCoupleableRollingStock stock) {
        return this.getCouplerFor(stock) != null;
    }

    public void decouple() {
        this.decouple(CouplerType.FRONT);
        this.decouple(CouplerType.BACK);
    }

    public void decouple(EntityCoupleableRollingStock stock) {
        if (stock.getPersistentID().equals(this.getCoupledUUID(CouplerType.FRONT))) {
            this.decouple(CouplerType.FRONT);
        } else if (stock.getPersistentID().equals(this.getCoupledUUID(CouplerType.BACK))) {
            this.decouple(CouplerType.BACK);
        }
    }

    public void decouple(CouplerType coupler) {
        EntityCoupleableRollingStock coupled = this.getCoupled(coupler);
        ImmersiveRailroading.info(this.getPersistentID() + " decouple " + (Object)((Object)coupler), new Object[0]);
        this.setCoupledUUID(coupler, null);
        if (coupled != null) {
            coupled.decouple(this);
        }
    }

    private Vec3d getCouplerPositionTo(CouplerType coupler, TickPos myPos, TickPos coupledPos) {
        return myPos.position.func_178787_e(myPos.position.func_72444_a(coupledPos.position).func_72432_b().func_186678_a(this.getDefinition().getCouplerPosition(coupler, this.gauge)));
    }

    @Override
    protected void clearPositionCache() {
        super.clearPositionCache();
        this.couplerFrontPosition = null;
        this.couplerRearPosition = null;
    }

    public Vec3d getCouplerPosition(CouplerType coupler) {
        return this.getCouplerPosition(coupler, this.getCurrentTickPosOrFake());
    }

    public Vec3d getCouplerPosition(CouplerType coupler, TickPos pos) {
        if (coupler == CouplerType.FRONT) {
            if (this.couplerFrontPosition == null) {
                this.couplerFrontPosition = this.predictRearBogeyPosition(pos, (float)(-(this.getDefinition().getCouplerPosition(coupler, this.gauge) + (double)this.getDefinition().getBogeyRear(this.gauge)))).func_178787_e(pos.position).func_72441_c(0.0, 1.0, 0.0);
            }
            return this.couplerFrontPosition;
        }
        if (this.couplerRearPosition == null) {
            this.couplerRearPosition = this.predictFrontBogeyPosition(pos, (float)(this.getDefinition().getCouplerPosition(coupler, this.gauge) - (double)this.getDefinition().getBogeyFront(this.gauge))).func_178787_e(pos.position).func_72441_c(0.0, 1.0, 0.0);
        }
        return this.couplerRearPosition;
    }

    public Pair<EntityCoupleableRollingStock, CouplerType> potentialCouplings(CouplerType coupler) {
        final List<EntityCoupleableRollingStock> train = this.getTrain();
        List nearBy = this.field_70170_p.func_175644_a(EntityCoupleableRollingStock.class, (Predicate)new Predicate<EntityCoupleableRollingStock>(){

            public boolean apply(@Nullable EntityCoupleableRollingStock entity) {
                if (entity == null) {
                    return false;
                }
                if (entity.field_70128_L) {
                    return false;
                }
                if (entity.func_70032_d(EntityCoupleableRollingStock.this) > 64.0f) {
                    return false;
                }
                if (entity.gauge != EntityCoupleableRollingStock.this.gauge) {
                    return false;
                }
                for (EntityCoupleableRollingStock stock : train) {
                    if (!stock.func_110124_au().equals(entity.func_110124_au())) continue;
                    return false;
                }
                return true;
            }
        });
        Pair bestMatch = null;
        double bestDistance = 100.0;
        Vec3d myCouplerPos = this.getCouplerPosition(coupler);
        Vec3d myOppositeCouplerPos = this.getCouplerPosition(coupler.opposite());
        for (EntityCoupleableRollingStock stock : nearBy) {
            AxisAlignedBB myBB;
            double couplerDistRear;
            Vec3d stockFrontPos = stock.getCouplerPosition(CouplerType.FRONT);
            Vec3d stockBackPos = stock.getCouplerPosition(CouplerType.BACK);
            double couplerDistFront = this.func_174791_d().func_72438_d(stockFrontPos);
            CouplerType otherCoupler = couplerDistFront < (couplerDistRear = this.func_174791_d().func_72438_d(stockBackPos)) ? CouplerType.FRONT : CouplerType.BACK;
            if (stock.isCoupled(otherCoupler)) continue;
            Vec3d stockCouplerPos = otherCoupler == CouplerType.FRONT ? stockFrontPos : stockBackPos;
            double myCouplerToOtherCoupler = myCouplerPos.func_72438_d(stockCouplerPos);
            double myCenterToMyCoupler = this.func_174791_d().func_72438_d(myCouplerPos);
            double myCenterToOtherCoupler = this.func_174791_d().func_72438_d(stockCouplerPos);
            double myCouplerToOtherCenter = myCouplerPos.func_72438_d(stock.func_174791_d());
            double myOppositeCouplerToOtherCenter = myOppositeCouplerPos.func_72438_d(stock.func_174791_d());
            if (myCouplerToOtherCoupler > bestDistance || (!(myCenterToMyCoupler < myCenterToOtherCoupler) || !this.isCouplerEngaged(coupler) || !stock.isCouplerEngaged(otherCoupler) ? !(myBB = this.func_70046_E().func_191195_a(0.0, 0.0, 0.25)).func_72318_a(stockCouplerPos) : myCouplerToOtherCoupler > Config.ConfigDebug.couplerRange)) continue;
            if (myCouplerToOtherCenter > myOppositeCouplerToOtherCenter || (stock = this.findByUUID(stock.func_110124_au())) == null) continue;
            bestMatch = Pair.of((Object)((Object)stock), (Object)((Object)otherCoupler));
            bestDistance = myCouplerToOtherCoupler;
        }
        return bestMatch;
    }

    public void triggerTrain() {
        for (EntityCoupleableRollingStock stock : this.getTrain()) {
            stock.triggerResimulate();
        }
    }

    public final List<EntityCoupleableRollingStock> getTrain() {
        return this.getTrain(true);
    }

    public final List<EntityCoupleableRollingStock> getTrain(boolean followDisengaged) {
        ArrayList<EntityCoupleableRollingStock> train = new ArrayList<EntityCoupleableRollingStock>();
        this.mapTrain(this, followDisengaged, train::add);
        return train;
    }

    public final void mapTrain(EntityCoupleableRollingStock prev, boolean followDisengaged, Consumer<EntityCoupleableRollingStock> fn) {
        this.mapTrain(prev, true, followDisengaged, (e, b) -> fn.accept((EntityCoupleableRollingStock)((Object)e)));
    }

    public final void mapTrain(EntityCoupleableRollingStock prev, boolean direction, boolean followDisengaged, BiConsumer<EntityCoupleableRollingStock, Boolean> fn) {
        for (DirectionalStock stock : this.getDirectionalTrain(followDisengaged)) {
            fn.accept(stock.stock, stock.direction);
        }
    }

    public Collection<DirectionalStock> getDirectionalTrain(boolean followDisengaged) {
        HashSet<UUID> trainMap = new HashSet<UUID>();
        ArrayList<DirectionalStock> trainList = new ArrayList<DirectionalStock>();
        Function<DirectionalStock, DirectionalStock> next = current -> {
            for (CouplerType coupler : CouplerType.values()) {
                EntityCoupleableRollingStock coupled;
                EntityCoupleableRollingStock stock = current.stock;
                boolean direction = current.direction;
                if (stock.getCoupledUUID(coupler) == null || trainMap.contains(stock.getCoupledUUID(coupler)) || !followDisengaged && !stock.isCouplerEngaged(coupler) || (coupled = stock.getCoupled(coupler)) == null) continue;
                CouplerType otherCoupler = coupled.getCouplerFor(stock);
                if (!followDisengaged && !coupled.isCouplerEngaged(otherCoupler)) continue;
                return new DirectionalStock(stock, coupled, coupler.opposite() == otherCoupler ? direction : !direction);
            }
            return null;
        };
        DirectionalStock start = new DirectionalStock(null, this, true);
        trainMap.add(start.stock.getPersistentID());
        trainList.add(start);
        for (int i = 0; i < 2; ++i) {
            DirectionalStock current2 = next.apply(start);
            while (current2 != null) {
                trainMap.add(current2.stock.getPersistentID());
                trainList.add(current2);
                current2 = next.apply(current2);
            }
        }
        return trainList;
    }

    public EntityCoupleableRollingStock findByUUID(UUID uuid) {
        for (Object e : this.field_70170_p.field_72996_f) {
            EntityCoupleableRollingStock train;
            if (!(e instanceof EntityCoupleableRollingStock) || !(train = (EntityCoupleableRollingStock)((Object)e)).getPersistentID().equals(uuid)) continue;
            return train;
        }
        return null;
    }

    @Override
    public void triggerResimulate() {
        this.resimulate = true;
    }

    public static class DirectionalStock {
        public final EntityCoupleableRollingStock prev;
        public final EntityCoupleableRollingStock stock;
        public final boolean direction;

        public DirectionalStock(EntityCoupleableRollingStock prev, EntityCoupleableRollingStock stock, boolean direction) {
            this.prev = prev;
            this.stock = stock;
            this.direction = direction;
        }
    }

    public static enum CouplerType {
        FRONT(0.0f),
        BACK(180.0f);

        public final float yaw;

        private CouplerType(float yaw) {
            this.yaw = yaw;
        }

        public CouplerType opposite() {
            return this == FRONT ? BACK : FRONT;
        }

        public String toString() {
            return (this == FRONT ? ChatText.COUPLER_FRONT : ChatText.COUPLER_BACK).toString();
        }
    }
}

