/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.client;

import cf.terminator.laggoggles.Main;
import cf.terminator.laggoggles.util.ColorBlindMode;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Config(modid="laggoggles", name="LagGoggles-client")
public class ClientConfig {
    @Config.Comment(value={"Define the number of microseconds at which an object is marked with a deep red colour for WORLD lag."})
    public static int GRADIENT_MAXED_OUT_AT_MICROSECONDS = 25;
    @Config.Comment(value={"Define the number of microseconds at which an object is marked with a deep red colour for FPS lag."})
    public static int GRADIENT_MAXED_OUT_AT_NANOSECONDS_FPS = 50000;
    @Config.Comment(value={"What is the minimum amount of microseconds required before an object is tracked in the client?\nThis is only for WORLD lag.\nThis also affects the analyze results window"})
    public static int MINIMUM_AMOUNT_OF_MICROSECONDS_THRESHOLD = 1;
    @Config.Comment(value={"If you're colorblind, change this to fit your needs.\nAvailable options:\n- GREEN_TO_RED\n- BLUE_TO_RED\n- GREEN_TO_BLUE"})
    public static ColorBlindMode COLORS = ColorBlindMode.GREEN_TO_RED;

    @Mod.EventBusSubscriber
    public static class ConfigurationHolder {
        private static final MethodHandle CONFIGS_GETTER = ConfigurationHolder.findFieldGetter(ConfigManager.class, "CONFIGS");
        private static Configuration configuration;

        public static MethodHandle findFieldGetter(Class<?> clazz, String ... fieldNames) {
            Field field = ReflectionHelper.findField(clazz, (String[])fieldNames);
            try {
                return MethodHandles.lookup().unreflectGetter(field);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionHelper.UnableToAccessFieldException(fieldNames, (Exception)e);
            }
        }

        public static Configuration getConfiguration() {
            if (configuration == null) {
                try {
                    String fileName = "LagGoggles-client.cfg";
                    Map configsMap = CONFIGS_GETTER.invokeExact();
                    Optional<Map.Entry> entryOptional = configsMap.entrySet().stream().filter(entry -> "LagGoggles-client.cfg".equals(new File((String)entry.getKey()).getName())).findFirst();
                    if (entryOptional.isPresent()) {
                        configuration = (Configuration)entryOptional.get().getValue();
                    }
                }
                catch (Throwable e) {
                    Main.LOGGER.error("Failed to get Configuration instance", e);
                }
            }
            return configuration;
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("laggoggles")) {
                ConfigManager.load((String)"laggoggles", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

